/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateDestructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalDestructorException;
import org.osoa.sca.annotations.Destroy;

public class DestroyProcessor
extends BaseJavaClassVisitor {
    public DestroyProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Destroy annotation = method.getAnnotation(Destroy.class);
        if (annotation == null) {
            return;
        }
        if (method.getParameterTypes().length != 0) {
            throw new IllegalDestructorException("Destructor must not have argments", method);
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalDestructorException("Destructor must return void.", method);
        }
        if (type.getDestroyMethod() != null) {
            throw new DuplicateDestructorException("More than one destructor found on implementation");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalDestructorException("Destructor must be a public method. Invalid annotation @Destroy found on " + method);
        }
        type.setDestroyMethod(method);
    }
}

