/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.osoa.sca.annotations.AllowsPassByReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllowsPassByReferenceProcessor
extends BaseJavaClassVisitor {
    public AllowsPassByReferenceProcessor(AssemblyFactory factory) {
        super(factory);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        type.setAllowsPassByReference(clazz.isAnnotationPresent(AllowsPassByReference.class));
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        boolean pbr = method.isAnnotationPresent(AllowsPassByReference.class);
        if (pbr) {
            type.getAllowsPassByReferenceMethods().add(method);
        }
    }
}

