/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicatePropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalPropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidPropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyProcessor<A extends Annotation>
extends BaseJavaClassVisitor {
    private final Class<A> annotationClass;

    protected AbstractPropertyProcessor(AssemblyFactory assemblyFactory, Class<A> annotationClass) {
        super(assemblyFactory);
        this.annotationClass = annotationClass;
    }

    private boolean removeProperty(JavaElementImpl prop, JavaImplementation type) {
        if (prop == null) {
            return false;
        }
        List<Property> props = type.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            if (!props.get(i).getName().equals(prop.getName())) continue;
            props.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        Map<String, JavaElementImpl> properties;
        JavaElementImpl prop;
        A annotation = method.getAnnotation(this.annotationClass);
        if (annotation == null) {
            return;
        }
        if (!JavaIntrospectionHelper.isSetter(method)) {
            throw new IllegalPropertyException("Annotated method is not a setter: " + method, method);
        }
        String name = this.getName(annotation);
        if ((name == null || "".equals(name)) && (name = method.getName()).startsWith("set")) {
            name = JavaIntrospectionHelper.toPropertyName(method.getName());
        }
        if ((prop = (properties = type.getPropertyMembers()).get(name)) != null && prop.getElementType() != ElementType.FIELD) {
            throw new DuplicatePropertyException(name);
        }
        this.removeProperty(prop, type);
        JavaElementImpl element = new JavaElementImpl(method, 0);
        Property property = this.createProperty(name, element);
        this.initProperty(property, annotation);
        type.getProperties().add(property);
        properties.put(name, element);
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        Map<String, JavaElementImpl> properties;
        JavaElementImpl prop;
        A annotation = field.getAnnotation(this.annotationClass);
        if (annotation == null) {
            return;
        }
        String name = this.getName(annotation);
        if (name == null) {
            name = "";
        }
        if ("".equals(name) || name.equals(field.getType().getName())) {
            name = field.getName();
        }
        if ((prop = (properties = type.getPropertyMembers()).get(name)) != null && prop.getElementType() == ElementType.FIELD) {
            throw new DuplicatePropertyException(name);
        }
        if (prop == null) {
            JavaElementImpl element = new JavaElementImpl(field);
            Property property = this.createProperty(name, element);
            this.initProperty(property, annotation);
            type.getProperties().add(property);
            properties.put(name, element);
        }
    }

    @Override
    public void visitConstructorParameter(JavaParameterImpl parameter, JavaImplementation type) throws IntrospectionException {
        Map<String, JavaElementImpl> properties = type.getPropertyMembers();
        A annotation = parameter.getAnnotation(this.annotationClass);
        if (annotation != null) {
            JavaElementImpl prop;
            String name = this.getName(annotation);
            if (name == null) {
                name = parameter.getType().getName();
            }
            if (!("".equals(name) || "".equals(parameter.getName()) || name.equals(parameter.getName()))) {
                throw new InvalidConstructorException("Mismatched property name: " + parameter);
            }
            if ("".equals(name) && "".equals(parameter.getName())) {
                throw new InvalidPropertyException("Missing property name: " + parameter);
            }
            if ("".equals(name)) {
                name = parameter.getName();
            }
            if ((prop = properties.get(name)) != null && prop.getElementType() != ElementType.FIELD) {
                throw new DuplicatePropertyException(name);
            }
            this.removeProperty(prop, type);
            parameter.setName(name);
            parameter.setClassifer(this.annotationClass);
            Property property = this.createProperty(name, parameter);
            this.initProperty(property, annotation);
            type.getProperties().add(property);
            properties.put(name, parameter);
        }
    }

    protected abstract String getName(A var1);

    protected abstract void initProperty(Property var1, A var2) throws IntrospectionException;

    protected Property createProperty(String name, JavaElementImpl element) throws IntrospectionException {
        Property property = this.assemblyFactory.createProperty();
        property.setName(name);
        Class<?> baseType = JavaIntrospectionHelper.getBaseType(element.getType(), element.getGenericType());
        property.setXSDType(JavaXMLMapper.getXMLType(baseType));
        Class<?> javaType = element.getType();
        if (javaType.isArray() || Collection.class.isAssignableFrom(javaType)) {
            property.setMany(true);
        }
        return property;
    }
}

