/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.injection;

import java.lang.reflect.Array;
import java.util.List;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMultiplicityObjectFactory
implements ObjectFactory<Object> {
    private ObjectFactory[] factories;
    private Class interfaceType;

    public ArrayMultiplicityObjectFactory(Class interfaceType, List<ObjectFactory<?>> factories) {
        assert (interfaceType != null) : "Interface type was null";
        assert (factories != null) : "Object factories were null";
        this.interfaceType = interfaceType;
        this.factories = factories.toArray(new ObjectFactory[factories.size()]);
    }

    @Override
    public Object getInstance() throws ObjectCreationException {
        Object array = Array.newInstance(this.interfaceType, this.factories.length);
        for (int i = 0; i < this.factories.length; ++i) {
            Array.set(array, i, this.factories[i].getInstance());
        }
        return array;
    }
}

