/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.context.InstanceFactory;
import org.apache.tuscany.sca.implementation.java.context.ReflectiveInstanceWrapper;
import org.apache.tuscany.sca.implementation.java.injection.Injector;
import org.apache.tuscany.sca.implementation.java.invocation.EventInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveInstanceFactory<T>
implements InstanceFactory<T> {
    private final Constructor<T> ctr;
    private final ObjectFactory<?>[] ctrArgs;
    private final Injector<T>[] injectors;
    private final EventInvoker<T> initInvoker;
    private final EventInvoker<T> destroyInvoker;

    public ReflectiveInstanceFactory(Constructor<T> ctr, ObjectFactory<?>[] ctrArgs, Injector<T>[] injectors, EventInvoker<T> initInvoker, EventInvoker<T> destroyInvoker) {
        this.ctr = ctr;
        this.ctrArgs = ctrArgs;
        this.injectors = injectors;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
    }

    @Override
    public InstanceWrapper<T> newInstance() {
        T instance;
        try {
            if (this.ctrArgs != null) {
                Object[] args = new Object[this.ctrArgs.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.ctrArgs[i].getInstance();
                }
                instance = this.ctr.newInstance(args);
            } else {
                instance = this.ctr.newInstance(new Object[0]);
            }
        }
        catch (InstantiationException e) {
            String name = this.ctr.getDeclaringClass().getName();
            throw new AssertionError((Object)("Class is not instantiable [" + name + "]"));
        }
        catch (IllegalAccessException e) {
            String name = this.ctr.getName();
            throw new AssertionError((Object)("Constructor is not accessible [" + name + "]"));
        }
        catch (InvocationTargetException e) {
            String name = this.ctr.getName();
            throw new ObjectCreationException("Exception thrown by constructor: " + name, e);
        }
        if (this.injectors != null) {
            for (Injector<T> injector : this.injectors) {
                if (injector == null) continue;
                injector.inject(instance);
            }
        }
        return new ReflectiveInstanceWrapper<T>(instance, this.initInvoker, this.destroyInvoker);
    }
}

