/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.ejb.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.ejb.EJBImplementation;
import org.apache.tuscany.sca.implementation.ejb.EJBImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<EJBImplementation> {
    private static final QName IMPLEMENTATION_EJB = new QName("http://www.osoa.org/xmlns/sca/1.0", "implementation.ejb");
    private AssemblyFactory assemblyFactory;
    private EJBImplementationFactory implementationFactory;
    private Monitor monitor;

    public EJBImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = modelFactories.getFactory(EJBImplementationFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-ejb-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_EJB;
    }

    @Override
    public Class<EJBImplementation> getModelType() {
        return EJBImplementation.class;
    }

    @Override
    public EJBImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        EJBImplementation implementation = this.implementationFactory.createEJBImplementation();
        implementation.setUnresolved(true);
        String ejbLink = this.getString(reader, "ejb-link");
        if (ejbLink != null) {
            implementation.setEJBLink(ejbLink);
            int hashPosition = ejbLink.indexOf(35);
            if (hashPosition >= 0) {
                implementation.setURI(ejbLink.substring(hashPosition + 1));
            } else {
                implementation.setURI(ejbLink);
            }
        } else {
            this.error("EJBLinkAttributeMissing", reader, new Object[0]);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_EJB.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(EJBImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
        String uri = implementation.getURI();
        if (uri != null) {
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI(uri + ".componentType");
            componentType = resolver.resolveModel(ComponentType.class, componentType);
            if (!componentType.isUnresolved()) {
                implementation.getServices().addAll(componentType.getServices());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getProperties().addAll(componentType.getProperties());
            }
        }
        implementation.setUnresolved(false);
    }

    @Override
    public void write(EJBImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, IMPLEMENTATION_EJB.getNamespaceURI(), IMPLEMENTATION_EJB.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("ejb-link", implementation.getEJBLink()));
        this.writeEnd(writer);
    }
}

