/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.ejb.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.ComponentPreProcessor;
import org.apache.tuscany.sca.implementation.ejb.EJBImplementation;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EJBImplementationImpl
implements EJBImplementation,
ComponentPreProcessor {
    private List<Property> properties = new ArrayList<Property>();
    private List<Service> services = new ArrayList<Service>();
    private List<Reference> references = new ArrayList<Reference>();
    private String ejbLink;
    private String uri;
    private boolean unresolved;

    EJBImplementationImpl() {
    }

    @Override
    public ConstrainingType getConstrainingType() {
        return null;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public String getEJBLink() {
        return this.ejbLink;
    }

    @Override
    public void setConstrainingType(ConstrainingType constrainingType) {
    }

    @Override
    public void setEJBLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    @Override
    public void preProcess(Component component) {
        if (!(component instanceof RuntimeComponent)) {
            return;
        }
        RuntimeComponent rtc = (RuntimeComponent)component;
        for (ComponentReference reference : rtc.getReferences()) {
            if (this.getReference(reference.getName()) != null) continue;
            this.getReferences().add(this.createReference(reference));
        }
        for (ComponentProperty property : rtc.getProperties()) {
            if (this.getProperty(property.getName()) != null) continue;
            this.getProperties().add(this.createProperty(property));
        }
    }

    protected Reference getReference(String name) {
        for (Reference reference : this.getReferences()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    protected Reference createReference(Reference reference) {
        Reference newReference;
        try {
            newReference = (Reference)reference.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newReference;
    }

    protected Property getProperty(String name) {
        for (Property property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    protected Property createProperty(Property property) {
        Property newProperty;
        try {
            newProperty = (Property)property.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        return newProperty;
    }
}

