/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.xml;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.implementation.bpel.BPELFactory;
import org.apache.tuscany.sca.implementation.bpel.BPELProcessDefinition;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELImportElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkTypeElement;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.interfacedef.wsdl.xml.BPELPartnerLinkTypeExt;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELDocumentProcessor
extends BaseStAXArtifactProcessor
implements URLArtifactProcessor<BPELProcessDefinition> {
    public static final QName BPEL_PROCESS_DEFINITION = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "process");
    public static final QName BPEL_EXECUTABLE_DEFINITION = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "process");
    private static final String SCA_BPEL_NS = "http://docs.oasis-open.org/ns/opencsa/sca-bpel/200801";
    private static final String BPEL_NS = "http://schemas.xmlsoap.org/ws/2004/03/business-process/";
    private static final String BPEL_PLINK_NS = "http://schemas.xmlsoap.org/ws/2004/03/partner-link/";
    private static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    private static final QName PROCESS_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "process");
    private static final QName PARTNERLINK_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "partnerLink");
    private static final QName ONEVENT_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "onEvent");
    private static final QName RECEIVE_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "receive");
    private static final QName ONMESSAGE_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "onMessage");
    private static final QName INVOKE_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "invoke");
    private static final QName IMPORT_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/business-process/", "import");
    private static final String LINKTYPE_NAME = "partnerLinkType";
    private static final QName LINKTYPE_ELEMENT = new QName("http://schemas.xmlsoap.org/ws/2004/03/partner-link/", "partnerLinkType");
    public static final String NAME_ELEMENT = "name";
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final BPELFactory factory;
    private WSDLFactory WSDLfactory;
    private Monitor monitor;

    public BPELDocumentProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.factory = modelFactories.getFactory(BPELFactory.class);
        this.WSDLfactory = modelFactories.getFactory(WSDLFactory.class);
        this.monitor = monitor;
    }

    @Override
    public String getArtifactType() {
        return "*.bpel";
    }

    @Override
    public Class<BPELProcessDefinition> getModelType() {
        return BPELProcessDefinition.class;
    }

    @Override
    public BPELProcessDefinition read(URL contributionURL, URI artifactURI, URL artifactURL) throws ContributionReadException {
        BPELProcessDefinition processDefinition = null;
        try {
            processDefinition = this.readProcessDefinition(artifactURL);
            processDefinition.setURI(artifactURI.toString());
            processDefinition.setUnresolved(false);
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)artifactURL, ce);
        }
        return processDefinition;
    }

    @Override
    public void resolve(BPELProcessDefinition model, ModelResolver resolver) throws ContributionResolveException {
        List<BPELImportElement> theImports = model.getImports();
        for (BPELImportElement theImport : theImports) {
            WSDLDefinition resolved;
            if (!theImport.getImportType().equals(WSDL_NS)) continue;
            String wsdlLocation = theImport.getLocation();
            String wsdlNamespace = theImport.getNamespace();
            WSDLDefinition proxy = this.WSDLfactory.createWSDLDefinition();
            proxy.setUnresolved(true);
            proxy.setNamespace(wsdlNamespace);
            if (wsdlLocation != null) {
                proxy.setLocation(URI.create(wsdlLocation));
            }
            if ((resolved = resolver.resolveModel(WSDLDefinition.class, proxy)) != null && !resolved.isUnresolved()) {
                theImport.setWSDLDefinition(resolved);
                continue;
            }
            this.error("CannotResolveWSDLReference", (Object)resolver, wsdlLocation, wsdlNamespace);
            return;
        }
        List<BPELPartnerLinkTypeElement> thePLinkTypes = this.getPartnerLinkTypes(theImports);
        ArrayList<WSDLInterface> theInterfaces = new ArrayList<WSDLInterface>();
        Collection<PortType> thePortTypes = this.getAllPortTypes(theImports, theInterfaces, resolver);
        model.getPortTypes().addAll(thePortTypes);
        model.getInterfaces().addAll(theInterfaces);
        List<BPELPartnerLinkElement> thePartnerLinks = model.getPartnerLinks();
        for (BPELPartnerLinkElement thePartnerLink : thePartnerLinks) {
            QName partnerLinkType = thePartnerLink.getPartnerLinkType();
            BPELPartnerLinkTypeElement pLinkType = this.findPartnerLinkType(partnerLinkType, thePLinkTypes);
            if (pLinkType == null) {
                this.error("PartnerLinkNoMatchingType", (Object)thePartnerLink, thePartnerLink.getName());
                continue;
            }
            thePartnerLink.setPartnerLinkType(pLinkType);
        }
    }

    private List<BPELPartnerLinkTypeElement> getPartnerLinkTypes(List<BPELImportElement> theImports) throws ContributionResolveException {
        ArrayList<BPELPartnerLinkTypeElement> thePLinks = new ArrayList<BPELPartnerLinkTypeElement>();
        for (BPELImportElement theImport : theImports) {
            if (!theImport.getImportType().equals(WSDL_NS)) continue;
            ArrayList<Definition> wsdlDefinitions = new ArrayList<Definition>();
            WSDLDefinition theWSDL = theImport.getWSDLDefinition();
            wsdlDefinitions.add(theWSDL.getDefinition());
            for (WSDLDefinition importedWSDL : theWSDL.getImportedDefinitions()) {
                wsdlDefinitions.add(importedWSDL.getDefinition());
            }
            for (Definition wsdlDefinition : wsdlDefinitions) {
                for (ExtensibilityElement theElement : wsdlDefinition.getExtensibilityElements()) {
                    QName elementType = theElement.getElementType();
                    if (!elementType.equals(LINKTYPE_ELEMENT)) continue;
                    BPELPartnerLinkTypeExt pLinkExt = (BPELPartnerLinkTypeExt)theElement;
                    String name = pLinkExt.getName();
                    QName qName = new QName(wsdlDefinition.getTargetNamespace(), name);
                    BPELPartnerLinkTypeElement pLinkElement = new BPELPartnerLinkTypeElement(qName);
                    int count = 0;
                    for (int i = 0; i < 2; ++i) {
                        if (pLinkExt.getRoleName(i) == null) continue;
                        PortType pType = wsdlDefinition.getPortType(pLinkExt.getRolePortType(i));
                        if (count == 0) {
                            pLinkElement.setRole1(pLinkExt.getRoleName(i), pLinkExt.getRolePortType(i), pType);
                            ++count;
                            continue;
                        }
                        if (count != true) break;
                        pLinkElement.setRole2(pLinkExt.getRoleName(i), pLinkExt.getRolePortType(i), pType);
                        ++count;
                    }
                    if (count == 0) {
                        this.error("PartnerLinkTypeNoRoles", (Object)theElement, pLinkElement.getName());
                        throw new ContributionResolveException("partnerLinkType " + pLinkElement.getName() + " has no Roles defined");
                    }
                    thePLinks.add(pLinkElement);
                }
            }
        }
        return thePLinks;
    }

    private Collection<PortType> getAllPortTypes(List<BPELImportElement> theImports, Collection<WSDLInterface> theInterfaces, ModelResolver resolver) throws ContributionResolveException {
        ArrayList<PortType> thePortTypes = new ArrayList<PortType>();
        for (BPELImportElement theImport : theImports) {
            if (!theImport.getImportType().equals(WSDL_NS)) continue;
            ArrayList<Definition> wsdlDefinitions = new ArrayList<Definition>();
            WSDLDefinition theWSDL = theImport.getWSDLDefinition();
            wsdlDefinitions.add(theWSDL.getDefinition());
            for (WSDLDefinition importedWSDL : theWSDL.getImportedDefinitions()) {
                wsdlDefinitions.add(importedWSDL.getDefinition());
            }
            for (Definition wsdlDefinition : wsdlDefinitions) {
                Collection portTypes = wsdlDefinition.getPortTypes().values();
                thePortTypes.addAll(portTypes);
                for (PortType portType : portTypes) {
                    WSDLInterface wsdlInterface;
                    WSDLObject<PortType> wsdlPortType = theWSDL.getWSDLObject(PortType.class, portType.getQName());
                    if (wsdlPortType == null) continue;
                    try {
                        theWSDL.setDefinition(wsdlPortType.getDefinition());
                        wsdlInterface = this.WSDLfactory.createWSDLInterface(wsdlPortType.getElement(), theWSDL, resolver);
                        wsdlInterface.setWsdlDefinition(theWSDL);
                    }
                    catch (InvalidInterfaceException e) {
                        ContributionResolveException ce = new ContributionResolveException(e);
                        this.error("ContributionResolveException", (Object)resolver, ce);
                        throw ce;
                    }
                    resolver.addModel(wsdlInterface);
                    theInterfaces.add(wsdlInterface);
                }
            }
        }
        return thePortTypes;
    }

    private BPELPartnerLinkTypeElement findPartnerLinkType(QName partnerLinkTypeName, List<BPELPartnerLinkTypeElement> thePLinkTypes) {
        for (BPELPartnerLinkTypeElement thePLinkType : thePLinkTypes) {
            if (!thePLinkType.getName().equals(partnerLinkTypeName)) continue;
            return thePLinkType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BPELProcessDefinition readProcessDefinition(URL doc) throws Exception {
        BPELProcessDefinition processDefinition = this.factory.createBPELProcessDefinition();
        processDefinition.setUnresolved(true);
        processDefinition.setLocation(doc.toString());
        InputStream is = doc.openStream();
        XMLStreamReader reader = null;
        try {
            reader = inputFactory.createXMLStreamReader(is);
            boolean completed = false;
            while (!completed) {
                switch (reader.next()) {
                    case 1: {
                        QName qname = reader.getName();
                        if (BPEL_PROCESS_DEFINITION.equals(qname) || BPEL_EXECUTABLE_DEFINITION.equals(qname)) {
                            QName processName = new QName(this.getString(reader, "targetNamespace"), this.getString(reader, NAME_ELEMENT));
                            processDefinition.setName(processName);
                            break;
                        }
                        if (PARTNERLINK_ELEMENT.equals(qname)) {
                            processDefinition.getPartnerLinks().add(this.processPartnerLinkElement(reader));
                            break;
                        }
                        if (ONEVENT_ELEMENT.equals(qname) || RECEIVE_ELEMENT.equals(qname) || ONMESSAGE_ELEMENT.equals(qname)) {
                            this.processPartnerLinkAsService(reader.getAttributeValue(null, "partnerLink"), processDefinition.getPartnerLinks());
                            break;
                        }
                        if (INVOKE_ELEMENT.equals(qname)) {
                            this.processPartnerLinkAsReference(reader.getAttributeValue(null, "partnerLink"), processDefinition.getPartnerLinks());
                            break;
                        }
                        if (!IMPORT_ELEMENT.equals(qname)) break;
                        processDefinition.getImports().add(this.processImportElement(reader));
                        break;
                    }
                    case 2: {
                        if (!PROCESS_ELEMENT.equals(reader.getName())) break;
                        completed = true;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            is.close();
        }
        return processDefinition;
    }

    private BPELPartnerLinkElement processPartnerLinkElement(XMLStreamReader reader) throws ContributionReadException {
        BPELPartnerLinkElement partnerLink = new BPELPartnerLinkElement(reader.getAttributeValue(null, NAME_ELEMENT), this.getQNameValue(reader, reader.getAttributeValue(null, LINKTYPE_NAME)), reader.getAttributeValue(null, "myRole"), reader.getAttributeValue(null, "partnerRole"));
        String scaService = reader.getAttributeValue(SCA_BPEL_NS, "service");
        String scaReference = reader.getAttributeValue(SCA_BPEL_NS, "reference");
        if (scaService != null && scaReference != null) {
            this.error("PartnerLinkHasBothAttr", (Object)partnerLink, reader.getAttributeValue(null, NAME_ELEMENT));
            throw new ContributionReadException("BPEL PartnerLink " + reader.getAttributeValue(null, NAME_ELEMENT) + " has both sca:reference and sca:service attributes set");
        }
        if (scaService != null) {
            partnerLink.setAsService(scaService);
        } else if (scaReference != null) {
            partnerLink.setAsReference(scaReference);
        }
        return partnerLink;
    }

    private BPELImportElement processImportElement(XMLStreamReader reader) {
        return new BPELImportElement(reader.getAttributeValue(null, "location"), reader.getAttributeValue(null, "importType"), reader.getAttributeValue(null, "namespace"));
    }

    private void processPartnerLinkAsService(String partnerLinkName, List<BPELPartnerLinkElement> partnerLinks) {
        BPELPartnerLinkElement partnerLink = this.findPartnerLinkByName(partnerLinks, partnerLinkName);
        if (partnerLink == null) {
            this.warning("ReferencePartnerLinkNotInList", partnerLinkName, partnerLinkName);
        } else if (!partnerLink.isSCATyped()) {
            partnerLink.setAsService(partnerLinkName);
        }
    }

    private void processPartnerLinkAsReference(String partnerLinkName, List<BPELPartnerLinkElement> partnerLinks) {
        BPELPartnerLinkElement partnerLink = this.findPartnerLinkByName(partnerLinks, partnerLinkName);
        if (partnerLink == null) {
            this.warning("ReferencePartnerLinkNotInList", partnerLinkName, partnerLinkName);
        } else if (!partnerLink.isSCATyped()) {
            partnerLink.setAsReference(partnerLinkName);
        }
    }

    private BPELPartnerLinkElement findPartnerLinkByName(List<BPELPartnerLinkElement> partnerLinks, String partnerLinkName) {
        for (BPELPartnerLinkElement thePartnerLink : partnerLinks) {
            if (!thePartnerLink.getName().equals(partnerLinkName)) continue;
            return thePartnerLink;
        }
        return null;
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }
}

