/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.ode.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Future;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.tuscany.sca.implementation.bpel.ode.EmbeddedODEServer;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BPELInvoker
implements Invoker {
    protected final Log __log = LogFactory.getLog(this.getClass());
    private EmbeddedODEServer odeServer;
    private TransactionManager txMgr;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private Operation operation;
    private QName bpelServiceName;
    private String bpelOperationName;
    private Part bpelOperationInputPart;
    private Part bpelOperationOutputPart;

    public BPELInvoker(RuntimeComponent component, RuntimeComponentService service, Operation operation, EmbeddedODEServer odeServer, TransactionManager txMgr) {
        this.component = component;
        this.service = service;
        this.operation = operation;
        this.bpelOperationName = operation.getName();
        this.odeServer = odeServer;
        this.txMgr = txMgr;
        this.initializeInvocation();
    }

    private void initializeInvocation() {
        this.__log.debug((Object)"Initializing BPELInvoker");
        Interface interfaze = this.operation.getInterface();
        if (interfaze instanceof WSDLInterface) {
            WSDLInterface wsdlInterface = null;
            wsdlInterface = (WSDLInterface)interfaze;
            this.bpelServiceName = new QName("http://tuscany.apache.org", this.service.getName());
            this.bpelOperationInputPart = (Part)wsdlInterface.getPortType().getOperation(this.bpelOperationName, null, null).getInput().getMessage().getParts().values().iterator().next();
            this.bpelOperationOutputPart = (Part)wsdlInterface.getPortType().getOperation(this.bpelOperationName, null, null).getOutput().getMessage().getParts().values().iterator().next();
        }
    }

    public org.apache.tuscany.sca.invocation.Message invoke(org.apache.tuscany.sca.invocation.Message msg) {
        try {
            Object[] args = (Object[])msg.getBody();
            Object resp = this.doTheWork(args);
            msg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            msg.setFaultBody(e.getCause());
        }
        return msg;
    }

    public Object doTheWork(Object[] args) throws InvocationTargetException {
        Element response = null;
        if (!(this.operation.getInterface() instanceof WSDLInterface)) {
            throw new InvocationTargetException(null, "Unsupported service contract");
        }
        System.out.println("Invoking bpel component : " + this.bpelServiceName + "#" + this.bpelOperationName);
        MyRoleMessageExchange mex = null;
        Future onhold = null;
        try {
            this.txMgr.begin();
            mex = this.odeServer.getBpelServer().getEngine().createMessageExchange(new GUID().toString(), this.bpelServiceName, this.bpelOperationName);
            onhold = mex.invoke(this.createInvocationMessage(mex, args));
            this.txMgr.commit();
        }
        catch (Exception e) {
            try {
                this.txMgr.rollback();
            }
            catch (SystemException se) {
                // empty catch block
            }
            throw new InvocationTargetException(e, "Error invoking BPEL process : " + e.getMessage());
        }
        if (onhold != null) {
            try {
                onhold.get();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, "Error invoking BPEL process : " + e.getMessage());
            }
        }
        try {
            this.txMgr.begin();
            mex = (MyRoleMessageExchange)this.odeServer.getBpelServer().getEngine().getMessageExchange(mex.getMessageExchangeId());
            MessageExchange.Status status = mex.getStatus();
            Element invocationResponse = mex.getResponse().getMessage();
            System.out.println(">>>Invocation status:" + status.name());
            System.out.println(">>>Response:\n" + DOMUtils.domToString((Node)invocationResponse));
            System.out.println(">>>Response:\n" + DOMUtils.domToString((Node)invocationResponse));
            response = this.processResponse(mex.getResponse().getMessage());
            this.txMgr.commit();
        }
        catch (Exception e) {
            try {
                this.txMgr.rollback();
            }
            catch (SystemException se) {
                // empty catch block
            }
            throw new InvocationTargetException(e, "Error retrieving BPEL process invocation status : " + e.getMessage());
        }
        return response;
    }

    private Message createInvocationMessage(MyRoleMessageExchange mex, Object[] args) {
        Document dom = DOMUtils.newDocument();
        Element contentMessage = dom.createElement("message");
        Element contentPart = dom.createElement(this.bpelOperationInputPart.getName());
        Element payload = null;
        payload = args[0] instanceof Document ? (Element)((Document)args[0]).getFirstChild() : (Element)args[0];
        contentPart.appendChild(dom.importNode(payload, true));
        contentMessage.appendChild(contentPart);
        dom.appendChild(contentMessage);
        System.out.println("Creating invocation message:");
        System.out.println(">> args.....: " + DOMUtils.domToString((Node)payload));
        System.out.println(">> message..:" + DOMUtils.domToString((Node)dom.getDocumentElement()));
        Message request = mex.createMessage(new QName("", ""));
        request.setMessage(dom.getDocumentElement());
        return request;
    }

    private Element processResponse(Element response) {
        return DOMUtils.findChildByName((Element)response, (QName)new QName("", this.bpelOperationOutputPart.getName()));
    }
}

