/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.ode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.BpelC;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.implementation.bpel.BPELImplementation;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TuscanyProcessConfImpl
implements ProcessConf {
    private final Log __log = LogFactory.getLog(this.getClass());
    private BPELImplementation implementation;
    private Map<String, Endpoint> invokeEndpoints = null;
    private Map<String, Endpoint> provideEndpoints = null;
    private Map<QName, Node> properties = null;
    private ProcessState processState;
    private Date deployDate;
    private final String TUSCANY_NAMESPACE = "http://tuscany.apache.org";

    public TuscanyProcessConfImpl(BPELImplementation theImplementation) {
        this.implementation = theImplementation;
        this.processState = ProcessState.ACTIVE;
        this.deployDate = new Date();
        this.compile(this.getBPELFile());
    }

    public URI getBaseURI() {
        File theDir = this.getDirectory();
        return theDir.toURI();
    }

    public String getBpelDocument() {
        try {
            File processFile = new File(URI.create(this.implementation.getProcessDefinition().getLocation()));
            return this.getRelativePath(this.getDirectory(), processFile);
        }
        catch (Exception e) {
            if (this.__log.isWarnEnabled()) {
                this.__log.warn((Object)("Unable to resolve relative path of BPEL process" + this.implementation.getProcessDefinition().getLocation()), (Throwable)e);
            }
            return null;
        }
    }

    public InputStream getCBPInputStream() {
        String cbpFileName;
        block8: {
            cbpFileName = null;
            try {
                String fileName = this.getRelativePath(this.getDirectory(), this.getBPELFile());
                cbpFileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".cbp";
            }
            catch (Exception e) {
                if (!this.__log.isDebugEnabled()) break block8;
                this.__log.debug((Object)("Unable to calculate the file name for BPEL process: " + this.implementation.getProcessDefinition().getName()), (Throwable)e);
                return null;
            }
        }
        File cbpFile = new File(this.getDirectory(), cbpFileName);
        if (cbpFile.exists()) {
            try {
                return new FileInputStream(cbpFile);
            }
            catch (Exception e) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Unable to open the cbp file for BPEL process: " + this.implementation.getProcessDefinition().getName()), (Throwable)e);
                }
            }
        } else if (this.__log.isWarnEnabled()) {
            this.__log.warn((Object)("Cannot find the cbp file for process: " + this.implementation.getProcessDefinition().getName()));
        }
        return null;
    }

    public Definition getDefinitionForPortType(QName portTypeName) {
        List<WSDLInterface> theInterfaces = this.implementation.getProcessDefinition().getInterfaces();
        for (WSDLInterface wsdlInterface : theInterfaces) {
            if (!wsdlInterface.getPortType().getQName().equals(portTypeName)) continue;
            return wsdlInterface.getWsdlDefinition().getDefinition();
        }
        return null;
    }

    public Definition getDefinitionForService(QName serviceQName) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("getDefinitionforService called for service: " + serviceQName));
        }
        return null;
    }

    public Date getDeployDate() {
        return this.deployDate;
    }

    public String getDeployer() {
        return "SCA Tuscany";
    }

    public List<File> getFiles() {
        File theDir = this.getDirectory();
        List<File> theFiles = Arrays.asList(theDir.listFiles());
        return theFiles;
    }

    public Map<String, Endpoint> getInvokeEndpoints() {
        if (this.invokeEndpoints == null) {
            this.invokeEndpoints = new HashMap<String, Endpoint>();
            List<Reference> theReferences = this.implementation.getReferences();
            for (Reference reference : theReferences) {
                this.invokeEndpoints.put(reference.getName(), new Endpoint(new QName("http://tuscany.apache.org", reference.getName()), "ReferencePort"));
            }
        }
        return this.invokeEndpoints;
    }

    public String getPackage() {
        File theDir = this.getDirectory();
        return theDir.getName();
    }

    public QName getProcessId() {
        QName processType = this.getType();
        QName processID = new QName(processType.getNamespaceURI(), processType.getLocalPart() + "-" + this.getVersion());
        return processID;
    }

    public Map<QName, Node> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<QName, Node>();
        }
        return this.properties;
    }

    public Map<String, Endpoint> getProvideEndpoints() {
        if (this.provideEndpoints == null) {
            this.provideEndpoints = new HashMap<String, Endpoint>();
            List<Service> theServices = this.implementation.getServices();
            for (Service service : theServices) {
                this.provideEndpoints.put(service.getName(), new Endpoint(new QName("http://tuscany.apache.org", service.getName()), "ServicePort"));
            }
        }
        return this.provideEndpoints;
    }

    public ProcessState getState() {
        return this.processState;
    }

    public QName getType() {
        return this.implementation.getProcess();
    }

    public long getVersion() {
        return 1L;
    }

    public boolean isEventEnabled(List<String> scopeNames, BpelEvent.TYPE type) {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    private void compile(File bpelFile) {
        block2: {
            BpelC compiler = BpelC.newBpelCompiler();
            HashMap processProps = new HashMap();
            HashMap compileProps = new HashMap();
            compileProps.put("customProps", processProps);
            compiler.setCompileProperties(compileProps);
            compiler.setBaseDirectory(this.getDirectory());
            try {
                compiler.compile(bpelFile);
            }
            catch (IOException e) {
                if (!this.__log.isDebugEnabled()) break block2;
                this.__log.debug((Object)("Compile error in " + bpelFile), (Throwable)e);
            }
        }
    }

    private File getDirectory() {
        File theDir = this.getBPELFile().getParentFile();
        return theDir;
    }

    private File getBPELFile() {
        try {
            File theProcess = new File(URI.create(this.implementation.getProcessDefinition().getLocation()));
            return theProcess;
        }
        catch (Exception e) {
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("Exception converting BPEL file URL to an URI: " + e));
            }
            return null;
        }
    }

    private String getRelativePath(File base, File path) throws IOException {
        String basePath = base.getCanonicalPath();
        String filePath = path.getCanonicalPath();
        if (!filePath.startsWith(basePath)) {
            throw new IOException("Invalid relative path: base=" + base + " path=" + path);
        }
        String relative = filePath.substring(basePath.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return relative;
    }

    public List<String> getMexInterceptors(QName processId) {
        System.out.println("getMexInterceptors for processID: " + processId);
        return null;
    }

    public void setTransient(boolean t) {
        System.out.println("setTransient called with boolean: " + t);
    }

    public List<Element> getExtensionElement(QName arg0) {
        return Collections.emptyList();
    }
}

