/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.jetty.module;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.http.jetty.JettyServer;
import org.apache.tuscany.sca.work.WorkScheduler;

public class JettyRuntimeModuleActivator
implements ModuleActivator {
    private static final Logger logger = Logger.getLogger(JettyRuntimeModuleActivator.class.getName());
    private JettyServer server;

    public void start(ExtensionPointRegistry extensionPointRegistry) {
        ServletHostExtensionPoint servletHosts = extensionPointRegistry.getExtensionPoint(ServletHostExtensionPoint.class);
        if (servletHosts.getServletHosts().size() < 1) {
            UtilityExtensionPoint utilities = extensionPointRegistry.getExtensionPoint(UtilityExtensionPoint.class);
            final WorkScheduler workScheduler = utilities.getUtility(WorkScheduler.class);
            try {
                this.server = AccessController.doPrivileged(new PrivilegedAction<JettyServer>(){

                    @Override
                    public JettyServer run() {
                        return new JettyServer(workScheduler);
                    }
                });
                servletHosts.addServletHost(this.server);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception creating JettyServer", e);
            }
        }
    }

    public void stop(ExtensionPointRegistry registry) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (JettyRuntimeModuleActivator.this.server != null) {
                    JettyRuntimeModuleActivator.this.server.stop();
                }
                return null;
            }
        });
    }
}

