/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.jetty;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.tuscany.sca.host.http.DefaultResourceServlet;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletMappingException;
import org.apache.tuscany.sca.http.jetty.JettyDefaultServlet;
import org.apache.tuscany.sca.http.jetty.JettyLogger;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.thread.ThreadPool;

public class JettyServer
implements ServletHost {
    private static final Logger logger = Logger.getLogger(JettyServer.class.getName());
    private final Object joinLock = new Object();
    private String trustStore;
    private String truststorePassword;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreType;
    private boolean sendServerVersion;
    private WorkScheduler workScheduler;
    private int defaultPort = 8080;
    private Map<Integer, Port> ports = new HashMap<Integer, Port>();
    private String contextPath = "/";

    public JettyServer(WorkScheduler workScheduler) {
        this.workScheduler = workScheduler;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JettyServer.this.trustStore = System.getProperty("javax.net.ssl.trustStore");
                JettyServer.this.truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                JettyServer.this.keyStore = System.getProperty("javax.net.ssl.keyStore");
                JettyServer.this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                JettyServer.this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                JettyServer.this.trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                return null;
            }
        });
    }

    public void setDefaultPort(int port) {
        this.defaultPort = port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.joinLock;
        synchronized (object) {
            this.joinLock.notifyAll();
        }
        try {
            HashSet<Map.Entry<Integer, Port>> entries = new HashSet<Map.Entry<Integer, Port>>(this.ports.entrySet());
            for (Map.Entry entry : entries) {
                Port port = (Port)entry.getValue();
                port.getServer().stop();
                this.ports.remove(entry.getKey());
            }
        }
        catch (Exception e) {
            throw new ServletMappingException(e);
        }
    }

    private void configureSSL(SslSocketConnector connector) {
        connector.setProtocol("TLS");
        connector.setKeystore(this.keyStore);
        connector.setKeyPassword(this.keyStorePassword);
        connector.setKeystoreType(this.keyStoreType);
        connector.setTruststore(this.trustStore);
        connector.setTrustPassword(this.truststorePassword);
        connector.setTruststoreType(this.trustStoreType);
        connector.setPassword(this.keyStorePassword);
        if (this.trustStore != null) {
            connector.setNeedClientAuth(true);
        }
    }

    public void addServletMapping(String suri, Servlet servlet) throws ServletMappingException {
        URL addedURL;
        String host;
        ServletHolder holder;
        Port port;
        int portNumber;
        URI uri = URI.create(suri);
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((portNumber = uri.getPort()) == -1) {
            portNumber = this.defaultPort;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            try {
                Server server = new Server();
                server.setThreadPool((ThreadPool)new WorkSchedulerThreadPool());
                if ("https".equals(scheme)) {
                    SslSocketConnector sslConnector = new SslSocketConnector();
                    sslConnector.setPort(portNumber);
                    this.configureSSL(sslConnector);
                    server.setConnectors(new Connector[]{sslConnector});
                } else {
                    SelectChannelConnector selectConnector = new SelectChannelConnector();
                    selectConnector.setPort(portNumber);
                    server.setConnectors(new Connector[]{selectConnector});
                }
                ContextHandler contextHandler = new ContextHandler();
                contextHandler.setContextPath("/");
                server.setHandler((Handler)contextHandler);
                SessionHandler sessionHandler = new SessionHandler();
                ServletHandler servletHandler = new ServletHandler();
                sessionHandler.addHandler((Handler)servletHandler);
                contextHandler.setHandler((Handler)sessionHandler);
                server.setStopAtShutdown(true);
                server.setSendServerVersion(this.sendServerVersion);
                server.start();
                port = new Port(server, servletHandler);
                this.ports.put(portNumber, port);
            }
            catch (Exception e) {
                throw new ServletMappingException(e);
            }
        }
        ServletHandler servletHandler = port.getServletHandler();
        if (servlet instanceof DefaultResourceServlet) {
            String servletPath = uri.getPath();
            if (servletPath.endsWith("*")) {
                servletPath = servletPath.substring(0, servletPath.length() - 1);
            }
            if (servletPath.endsWith("/")) {
                servletPath = servletPath.substring(0, servletPath.length() - 1);
            }
            if (!servletPath.startsWith("/")) {
                servletPath = '/' + servletPath;
            }
            DefaultResourceServlet resourceServlet = (DefaultResourceServlet)servlet;
            JettyDefaultServlet defaultServlet = new JettyDefaultServlet(servletPath, resourceServlet.getDocumentRoot());
            holder = new ServletHolder((Servlet)defaultServlet);
        } else {
            holder = new ServletHolder(servlet);
        }
        servletHandler.addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(holder.getName());
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        mapping.setPathSpec(path);
        servletHandler.addServletMapping(mapping);
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        try {
            addedURL = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException(e);
        }
        logger.info("Added Servlet mapping: " + addedURL);
    }

    public URL getURLMapping(String suri) throws ServletMappingException {
        URL url;
        String host;
        int portNumber;
        URI uri = URI.create(suri);
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((portNumber = uri.getPort()) == -1) {
            portNumber = this.defaultPort;
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        try {
            url = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException(e);
        }
        return url;
    }

    public Servlet getServletMapping(String suri) throws ServletMappingException {
        Port port;
        if (suri == null) {
            return null;
        }
        URI uri = URI.create(suri);
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            portNumber = this.defaultPort;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            return null;
        }
        ServletHandler servletHandler = port.getServletHandler();
        Servlet servlet = null;
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>(Arrays.asList(servletHandler.getServletMappings()));
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        for (ServletMapping mapping : mappings) {
            if (!Arrays.asList(mapping.getPathSpecs()).contains(path)) continue;
            try {
                servlet = servletHandler.getServlet(mapping.getServletName()).getServlet();
                break;
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        }
        return servlet;
    }

    public Servlet removeServletMapping(String suri) {
        Port port;
        URI uri = URI.create(suri);
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            portNumber = this.defaultPort;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            throw new IllegalStateException("No servlet registered at this URI: " + suri);
        }
        ServletHandler servletHandler = port.getServletHandler();
        Servlet removedServlet = null;
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>(Arrays.asList(servletHandler.getServletMappings()));
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        for (ServletMapping mapping : mappings) {
            if (!Arrays.asList(mapping.getPathSpecs()).contains(path)) continue;
            try {
                removedServlet = servletHandler.getServlet(mapping.getServletName()).getServlet();
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
            mappings.remove(mapping);
            logger.info("Removed Servlet mapping: " + path);
            break;
        }
        if (removedServlet != null) {
            servletHandler.setServletMappings(mappings.toArray(new ServletMapping[mappings.size()]));
            if (mappings.size() == 0) {
                try {
                    port.getServer().stop();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                this.ports.remove(portNumber);
            }
        } else {
            logger.warning("Trying to Remove servlet mapping: " + path + " where mapping is not registered");
        }
        return removedServlet;
    }

    public RequestDispatcher getRequestDispatcher(String suri) throws ServletMappingException {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String path) {
        this.contextPath = path;
    }

    static {
        System.setProperty("org.mortbay.log.class", JettyLogger.class.getName());
    }

    private class WorkSchedulerThreadPool
    implements ThreadPool {
        private WorkSchedulerThreadPool() {
        }

        public boolean dispatch(Runnable work) {
            JettyServer.this.workScheduler.scheduleWork(work);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join() throws InterruptedException {
            Object object = JettyServer.this.joinLock;
            synchronized (object) {
                JettyServer.this.joinLock.wait();
            }
        }

        public int getThreads() {
            throw new UnsupportedOperationException();
        }

        public int getIdleThreads() {
            throw new UnsupportedOperationException();
        }

        public boolean isLowOnThreads() {
            return false;
        }
    }

    private class Port {
        private Server server;
        private ServletHandler servletHandler;

        private Port(Server server, ServletHandler servletHandler) {
            this.server = server;
            this.servletHandler = servletHandler;
        }

        public Server getServer() {
            return this.server;
        }

        public ServletHandler getServletHandler() {
            return this.servletHandler;
        }
    }
}

