/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.tuscany.sca.host.webapp.WebAppServletHost;

public class TuscanyServletFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private WebAppServletHost servletHost;

    public void init(final FilterConfig config) throws ServletException {
        this.servletHost = WebAppServletHost.getInstance();
        this.servletHost.init(new ServletConfig(){

            public String getInitParameter(String name) {
                return config.getInitParameter(name);
            }

            public Enumeration getInitParameterNames() {
                return config.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return config.getServletContext();
            }

            public String getServletName() {
                return config.getFilterName();
            }
        });
    }

    public void destroy() {
        WebAppServletHost.getInstance().destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestDispatcher dispatcher;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getPathInfo();
        if (path == null) {
            path = httpRequest.getServletPath();
        }
        if (path == null) {
            path = "/";
        }
        if ((dispatcher = this.servletHost.getRequestDispatcher(path)) != null) {
            dispatcher.forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }
}

