/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.tuscany.sca.host.embedded.SCADomain;
import org.apache.tuscany.sca.host.webapp.WebAppServletHost;

public class TuscanyContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        final ServletContext servletContext = event.getServletContext();
        try {
            WebAppServletHost.getInstance().init(new ServletConfig(){

                public String getInitParameter(String name) {
                    return servletContext.getInitParameter(name);
                }

                public Enumeration getInitParameterNames() {
                    return servletContext.getInitParameterNames();
                }

                public ServletContext getServletContext() {
                    return servletContext;
                }

                public String getServletName() {
                    return null;
                }
            });
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        SCADomain scaDomain = (SCADomain)servletContext.getAttribute("org.apache.tuscany.sca.SCADomain");
        if (scaDomain != null) {
            scaDomain.close();
        }
    }
}

