/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.core.assembly.RuntimeComponentImpl;
import org.apache.tuscany.sca.host.embedded.impl.EmbeddedSCADomain;
import org.apache.tuscany.sca.host.embedded.management.ComponentListener;
import org.apache.tuscany.sca.host.embedded.management.ComponentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentManagerImpl
implements ComponentManager {
    protected List<ComponentListener> listeners = new CopyOnWriteArrayList<ComponentListener>();
    protected EmbeddedSCADomain domain;

    public ComponentManagerImpl(EmbeddedSCADomain domain) {
        this.domain = domain;
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Set<String> getComponentNames() {
        HashSet<String> names = new HashSet<String>();
        for (Composite composite : this.domain.getDomainComposite().getIncludes()) {
            for (Component component : composite.getComponents()) {
                names.add(component.getName());
            }
        }
        return names;
    }

    @Override
    public Component getComponent(String componentName) {
        for (Composite composite : this.domain.getDomainComposite().getIncludes()) {
            for (Component component : composite.getComponents()) {
                if (!component.getName().equals(componentName)) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    public void startComponent(String componentName) throws ActivationException {
        Component component = this.getComponent(componentName);
        if (component == null) {
            throw new IllegalArgumentException("no component: " + componentName);
        }
        this.domain.getCompositeActivator().start(component);
        this.notifyComponentStarted(componentName);
    }

    @Override
    public void stopComponent(String componentName) throws ActivationException {
        Component component = this.getComponent(componentName);
        if (component == null) {
            throw new IllegalArgumentException("no component: " + componentName);
        }
        this.domain.getCompositeActivator().stop(component);
        this.notifyComponentStopped(componentName);
    }

    public void notifyComponentStarted(String componentName) {
        for (ComponentListener listener : this.listeners) {
            try {
                listener.componentStarted(componentName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void notifyComponentStopped(String componentName) {
        for (ComponentListener listener : this.listeners) {
            try {
                listener.componentStopped(componentName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isComponentStarted(String componentName) {
        RuntimeComponentImpl runtimeComponent = (RuntimeComponentImpl)this.getComponent(componentName);
        return runtimeComponent.isStarted();
    }
}

