/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCATestCaseRunner {
    private ClassLoader classLoader;
    private Class<?> testSuiteClass;
    private Object testSuite;
    private Class<?> testResultClass;
    private Class<?> testCaseClass;
    private Object testCase;
    private Class<?> beforeAnnotation;
    private Class<?> beforeClassAnnotation;
    private Class<?> afterAnnotation;
    private Class<?> afterClassAnnotation;
    private Class<?> junit4AdapterClass;
    private Class<?> junit3TestCaseClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCATestCaseRunner(Class testClass) {
        block10: {
            try {
                ClassLoader finaltccl;
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                this.classLoader = testClass.getClassLoader();
                if (this.classLoader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)this.classLoader).getURLs();
                    this.classLoader = new URLClassLoader(urls, this.classLoader.getParent());
                } else {
                    this.classLoader = this.classLoader == tccl || this.classLoader.getParent() == tccl ? new URLClassLoader(new URL[0], this.classLoader) : tccl;
                }
                try {
                    final ClassLoader finalClassLoader = this.classLoader;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            Thread.currentThread().setContextClassLoader(finalClassLoader);
                            return null;
                        }
                    });
                    this.testCaseClass = Class.forName(testClass.getName(), true, this.classLoader);
                    this.testCase = this.testCaseClass.newInstance();
                    ClassLoader testClassLoader = this.testCaseClass.getClassLoader();
                    this.junit3TestCaseClass = Class.forName("junit.framework.TestCase", true, testClassLoader);
                    this.testSuiteClass = Class.forName("junit.framework.TestSuite", true, testClassLoader);
                    Constructor<?> testSuiteConstructor = this.testSuiteClass.getConstructor(Class.class);
                    this.testSuite = testSuiteConstructor.newInstance(this.testCaseClass);
                    this.testResultClass = Class.forName("junit.framework.TestResult", true, testClassLoader);
                    try {
                        this.beforeAnnotation = Class.forName("org.junit.Before", true, testClassLoader);
                        this.afterAnnotation = Class.forName("org.junit.After", true, testClassLoader);
                        this.beforeClassAnnotation = Class.forName("org.junit.BeforeClass", true, testClassLoader);
                        this.afterClassAnnotation = Class.forName("org.junit.AfterClass", true, testClassLoader);
                        this.junit4AdapterClass = Class.forName("junit.framework.JUnit4TestAdapter", true, testClassLoader);
                    }
                    catch (Exception e) {
                        throw new AssertionError((Object)e);
                    }
                    finaltccl = tccl;
                }
                catch (Throwable e) {
                    ClassLoader finaltccl2;
                    try {
                        e.printStackTrace();
                        finaltccl2 = tccl;
                    }
                    catch (Throwable throwable) {
                        ClassLoader finaltccl3 = tccl;
                        AccessController.doPrivileged(new PrivilegedAction<Object>(finaltccl3){
                            final /* synthetic */ ClassLoader val$finaltccl;
                            {
                                this.val$finaltccl = classLoader;
                            }

                            @Override
                            public Object run() {
                                Thread.currentThread().setContextClassLoader(this.val$finaltccl);
                                return null;
                            }
                        });
                        throw throwable;
                    }
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    break block10;
                }
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void run() {
        ClassLoader finaltccl;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            final ClassLoader finalClassLoader = this.classLoader;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(finalClassLoader);
                    return null;
                }
            });
            if (this.junit3TestCaseClass.isAssignableFrom(this.testCaseClass)) {
                Object testResult = this.testResultClass.newInstance();
                Method runMethod = this.testSuiteClass.getMethod("run", this.testResultClass);
                runMethod.invoke(this.testSuite, testResult);
            } else {
                Object junit4Adapter = this.junit4AdapterClass.getConstructor(Class.class).newInstance(this.testCaseClass);
                Object testResult = this.testResultClass.newInstance();
                Method runMethod = this.junit4AdapterClass.getMethod("run", this.testResultClass);
                runMethod.invoke(junit4Adapter, testResult);
            }
            finaltccl = tccl;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ClassLoader finaltccl2 = tccl;
                AccessController.doPrivileged(new PrivilegedAction<Object>(finaltccl2){
                    final /* synthetic */ ClassLoader val$finaltccl;
                    {
                        this.val$finaltccl = classLoader;
                    }

                    @Override
                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$finaltccl);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
    }

    public void setUp() {
        this.execute("setUp");
    }

    public void before() {
        this.execute(this.beforeAnnotation);
    }

    public void beforeClass() {
        this.execute(this.beforeClassAnnotation);
    }

    public void tearDown() {
        this.execute("tearDown");
    }

    public void after() {
        this.execute(this.afterAnnotation);
    }

    public void afterClass() {
        this.execute(this.afterClassAnnotation);
    }

    public void run(String methodName) {
        this.execute(methodName);
    }

    private void execute(Class<?> annotationClass) {
        ClassLoader finaltccl;
        if (annotationClass == null) {
            throw new RuntimeException(new NoSuchMethodException());
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            final ClassLoader finalClassLoader = this.classLoader;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(finalClassLoader);
                    return null;
                }
            });
            for (Method method : this.testCaseClass.getDeclaredMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (annotation.annotationType() != annotationClass) continue;
                    method.invoke(this.testCase, new Object[0]);
                }
            }
            finaltccl = tccl;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ClassLoader finaltccl2 = tccl;
                AccessController.doPrivileged(new PrivilegedAction<Object>(finaltccl2){
                    final /* synthetic */ ClassLoader val$finaltccl;
                    {
                        this.val$finaltccl = classLoader;
                    }

                    @Override
                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$finaltccl);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
    }

    private void execute(String methodName) {
        ClassLoader finaltccl;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            final ClassLoader finalClassLoader = this.classLoader;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(finalClassLoader);
                    return null;
                }
            });
            Method setUpMethod = this.testCaseClass.getDeclaredMethod(methodName, new Class[0]);
            setUpMethod.setAccessible(true);
            setUpMethod.invoke(this.testCase, new Object[0]);
            finaltccl = tccl;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ClassLoader finaltccl2 = tccl;
                AccessController.doPrivileged(new PrivilegedAction<Object>(finaltccl2){
                    final /* synthetic */ ClassLoader val$finaltccl;
                    {
                        this.val$finaltccl = classLoader;
                    }

                    @Override
                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$finaltccl);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
    }
}

