/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded;

import java.lang.reflect.Constructor;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.host.embedded.impl.DefaultSCADomain;
import org.apache.tuscany.sca.host.embedded.management.ComponentManager;
import org.osoa.sca.CallableReference;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCADomain {
    static final String LOCAL_DOMAIN_URI = "http://localhost";
    protected static SCADomain theDomain;

    public static SCADomain newInstance() {
        return SCADomain.createNewInstance(LOCAL_DOMAIN_URI, null, new String[0]);
    }

    public static SCADomain newInstance(String composite) {
        return SCADomain.createNewInstance(LOCAL_DOMAIN_URI, "/", composite);
    }

    public static SCADomain newInstance(String domainURI, String contributionLocation, String ... composites) {
        return SCADomain.createNewInstance(domainURI, contributionLocation, composites);
    }

    public static void removeInstance(SCADomain domainInstance) {
        theDomain = null;
    }

    public static SCADomain connect(String domainURI) {
        return theDomain;
    }

    public void close() {
        SCADomain.removeInstance(this);
    }

    public abstract String getURI();

    public abstract <B, R extends CallableReference<B>> R cast(B var1) throws IllegalArgumentException;

    public abstract <B> B getService(Class<B> var1, String var2);

    public abstract <B> ServiceReference<B> getServiceReference(Class<B> var1, String var2);

    static SCADomain createNewInstance(String domainURI, String contributionLocation, String ... composites) {
        SCADomain domain = null;
        try {
            ClassLoader runtimeClassLoader = SCADomain.class.getClassLoader();
            ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
            Class<?> implClass = ServiceDiscovery.getInstance().loadFirstServiceClass(SCADomain.class);
            if (implClass == null) {
                domain = new DefaultSCADomain(runtimeClassLoader, applicationClassLoader, domainURI, contributionLocation, composites);
            } else {
                Constructor<?> constructor = null;
                try {
                    constructor = implClass.getConstructor(ClassLoader.class, ClassLoader.class, String.class, String.class, String[].class);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (constructor != null) {
                    domain = (SCADomain)constructor.newInstance(runtimeClassLoader, applicationClassLoader, domainURI, contributionLocation, composites);
                } else {
                    constructor = implClass.getConstructor(ClassLoader.class, String.class);
                    domain = (SCADomain)constructor.newInstance(runtimeClassLoader, domainURI);
                }
            }
            theDomain = domain;
            return domain;
        }
        catch (ServiceRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public ComponentManager getComponentManager() {
        return null;
    }
}

