/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.corba.naming;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.tuscany.sca.host.corba.naming.TransientNamingContext;
import org.apache.tuscany.sca.host.corba.naming.TransientServiceException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class TransientNameService {
    public static final String DEFAULT_SERVICE_NAME = "TNameService";
    public static final int DEFAULT_SERVICE_PORT = 900;
    public static final String DEFAULT_SERVICE_HOST = "localhost";
    protected TransientNamingContext initialContext;
    protected int port;
    protected String host;
    protected String serviceName;
    protected ORB createdOrb;

    public TransientNameService() {
        this(DEFAULT_SERVICE_HOST, 900, DEFAULT_SERVICE_NAME);
    }

    public TransientNameService(String host, int port) {
        this(host, port, DEFAULT_SERVICE_NAME);
    }

    public TransientNameService(String host, int port, String name) {
        this.port = port;
        this.host = host;
        this.serviceName = name;
    }

    public void run() throws TransientServiceException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        String portStr = String.valueOf(this.port);
        props.put("org.omg.CORBA.ORBServerId", "1000000");
        props.put("org.omg.CORBA.ORBInitialHost", this.host);
        props.put("org.omg.CORBA.ORBInitialPort", portStr);
        props.put("com.sun.CORBA.POA.ORBPersistentServerPort", portStr);
        props.put("com.ibm.CORBA.ListenerPort", portStr);
        props.put("gnu.CORBA.ListenerPort", portStr);
        props.put("yoko.orb.oa.endpoint", "iiop --host " + this.host + " --port " + this.port);
        props.put("yoko.orb.poamanager.TNameService.endpoint", "iiop --host " + this.host);
        String[] args = new String[]{"-ORBInitialHost", this.host, "-ORBInitialPort", "" + this.port};
        this.createdOrb = ORB.init((String[])args, (Properties)props);
        this.initialize(this.createdOrb);
    }

    public void initialize(ORB orb) throws TransientServiceException {
        try {
            POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
            rootPOA.the_POAManager().activate();
            Policy[] policy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN)};
            POA nameServicePOA = rootPOA.create_POA(DEFAULT_SERVICE_NAME, null, policy);
            nameServicePOA.the_POAManager().activate();
            this.initialContext = new TransientNamingContext(orb, nameServicePOA);
            Object context = this.initialContext.getRootContext();
            Method method = orb.getClass().getMethod("register_initial_reference", String.class, Object.class);
            method.invoke((java.lang.Object)orb, this.serviceName, context);
            method.invoke((java.lang.Object)orb, "NamingService", context);
            method.invoke((java.lang.Object)orb, "NameService", context);
        }
        catch (Exception e) {
            throw new TransientServiceException("Unable to initialize name service", e);
        }
    }

    public void destroy() {
        if (this.createdOrb != null) {
            this.createdOrb.shutdown(false);
            this.createdOrb.destroy();
            try {
                Method m = this.createdOrb.getClass().getMethod("getTransportManager", new Class[0]);
                java.lang.Object tm = m.invoke((java.lang.Object)this.createdOrb, new java.lang.Object[0]);
                m = tm.getClass().getMethod("close", new Class[0]);
                m.invoke(tm, new java.lang.Object[0]);
                m = tm.getClass().getMethod("getAcceptors", new Class[0]);
                Collection acceptors = (Collection)m.invoke(tm, new java.lang.Object[0]);
                for (java.lang.Object a : acceptors) {
                    m = a.getClass().getMethod("close", new Class[0]);
                    m.invoke(a, new java.lang.Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.createdOrb = null;
        }
    }

    public ORB getORB() {
        return this.createdOrb;
    }
}

