/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.corba.naming;

import org.apache.tuscany.sca.host.corba.naming.TransientNameService;
import org.omg.CORBA.ORB;

public class TransientNameServer {
    private final TransientNameService service;
    private final Object flag = new Object();
    private Boolean started;

    public TransientNameServer(String host, int port, String serviceName) {
        this.service = new TransientNameService(host, port, serviceName);
    }

    public ORB getORB() {
        return this.service.getORB();
    }

    public Thread start() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ORB orb = null;
                Object object = TransientNameServer.this.flag;
                synchronized (object) {
                    try {
                        TransientNameServer.this.service.run();
                        orb = TransientNameServer.this.service.getORB();
                        TransientNameServer.this.started = Boolean.TRUE;
                    }
                    catch (Throwable e) {
                        TransientNameServer.this.started = Boolean.FALSE;
                        throw new IllegalStateException(e);
                    }
                    finally {
                        TransientNameServer.this.flag.notifyAll();
                    }
                }
                orb.run();
            }
        };
        t.setDaemon(true);
        t.start();
        this.checkState();
        return t.isAlive() ? t : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean checkState() {
        Object object = this.flag;
        synchronized (object) {
            while (this.started == null) {
                try {
                    this.flag.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return this.started;
        }
    }

    public void stop() {
        if (this.started == Boolean.TRUE) {
            this.service.destroy();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 900;
        String host = "localhost";
        String serviceName = "TNameService";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-ORBInitialPort")) {
                if (++i < args.length) {
                    port = Integer.parseInt(args[i]);
                    continue;
                }
                throw new IllegalArgumentException("Invalid -ORBInitialPort option");
            }
            if (args[i].equals("-ORBInitialHost")) {
                if (++i < args.length) {
                    host = args[i];
                    continue;
                }
                throw new IllegalArgumentException("Invalid -ORBInitialHost option");
            }
            if (!args[i].equals("-ORBServiceName")) continue;
            if (++i < args.length) {
                serviceName = args[i];
                continue;
            }
            throw new IllegalArgumentException("Invalid -ORBServiceName option");
        }
        TransientNameServer server = new TransientNameServer(host, port, serviceName);
        server.start().join();
    }
}

