/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.corba.jse;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.host.corba.CorbaHost;
import org.apache.tuscany.sca.host.corba.CorbaHostException;
import org.apache.tuscany.sca.host.corba.CorbaHostUtils;
import org.apache.tuscany.sca.host.corba.CorbanameURL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class DefaultCorbaHost
implements CorbaHost {
    private static final Logger logger = Logger.getLogger(DefaultCorbaHost.class.getName());
    private Map<String, ORB> orbs = new ConcurrentHashMap<String, ORB>();

    private void validatePort(int port) throws IllegalArgumentException {
        if (port < 1) {
            throw new IllegalArgumentException("Port value should be > 0");
        }
    }

    private NamingContextExt getNamingContext(ORB orb, String nameService) throws Exception {
        Object objRef = orb.resolve_initial_references(nameService);
        return NamingContextExtHelper.narrow((Object)objRef);
    }

    private void handleException(Exception e) throws CorbaHostException {
        if (e instanceof NotFound) {
            throw new CorbaHostException("There is no object under given location", e);
        }
        if (e instanceof InvalidName) {
            throw new CorbaHostException(e);
        }
        throw new CorbaHostException(e);
    }

    public void registerServant(String uri, Object servantObject) throws CorbaHostException {
        CorbanameURL details = CorbaHostUtils.getServiceDetails(uri);
        ORB orb = this.createORB(details.getHost(), details.getPort(), false);
        try {
            NamingContextExt namingCtx = this.getNamingContext(orb, details.getNameService());
            for (int i = 0; i < details.getNamePath().size() - 1; ++i) {
                NameComponent nc = new NameComponent(details.getNamePath().get(i), "");
                NameComponent[] path = new NameComponent[]{nc};
                try {
                    namingCtx = NamingContextHelper.narrow((Object)namingCtx.resolve(path));
                    continue;
                }
                catch (Exception e) {
                    namingCtx = namingCtx.bind_new_context(path);
                }
            }
            NameComponent finalName = new NameComponent(details.getNamePath().get(details.getNamePath().size() - 1), "");
            try {
                namingCtx.resolve(new NameComponent[]{finalName});
                throw new CorbaHostException("Binding name is already in use");
            }
            catch (NotFound e) {
                namingCtx.bind(new NameComponent[]{finalName}, servantObject);
            }
        }
        catch (CorbaHostException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void unregisterServant(String uri) throws CorbaHostException {
        CorbanameURL details = CorbaHostUtils.getServiceDetails(uri);
        ORB orb = this.createORB(details.getHost(), details.getPort(), false);
        try {
            NamingContextExt namingCtx = this.getNamingContext(orb, details.getNameService());
            namingCtx.unbind(namingCtx.to_name(details.getName()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Object lookup(String uri) throws CorbaHostException {
        Object result = null;
        try {
            CorbanameURL url = new CorbanameURL(uri);
            ORB orb = this.createORB(url.getHost(), url.getPort(), false);
            NamingContextExt context = this.getNamingContext(orb, url.getNameService());
            result = context.resolve_str(url.getName());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (result == null) {
            throw new CorbaHostException("There is no object under given location");
        }
        return result;
    }

    public ORB createORB(String host, int port, boolean server) throws CorbaHostException {
        this.validatePort(port);
        String key = host + ":" + port;
        ORB orb = this.orbs.get(key);
        if (orb != null) {
            return orb;
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        String portStr = String.valueOf(port);
        props.put("org.omg.CORBA.ORBServerId", "1000000");
        props.put("org.omg.CORBA.ORBInitialHost", host);
        props.put("org.omg.CORBA.ORBInitialPort", portStr);
        if (server) {
            props.put("com.sun.CORBA.POA.ORBPersistentServerPort", portStr);
            props.put("com.ibm.CORBA.ListenerPort", portStr);
            props.put("gnu.CORBA.ListenerPort", portStr);
            props.put("yoko.orb.oa.endpoint", "iiop --host " + host + " --port " + port);
            props.put("yoko.orb.poamanager.TNameService.endpoint", "iiop --host " + host);
        }
        String[] args = new String[]{"-ORBInitialHost", host, "-ORBInitialPort", "" + port};
        orb = ORB.init((String[])args, (Properties)props);
        this.orbs.put(key, orb);
        return orb;
    }

    public void stop() {
        for (ORB orb : this.orbs.values()) {
            try {
                orb.shutdown(true);
                orb.destroy();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

