/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.corba;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbanameURL {
    public static String DEFAULT_PROTOCOL = "iiop";
    public static String DEFAULT_VERSION = "";
    public static String DEFAULT_NAME_SERVICE = "NameService";
    public static String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 2809;
    private String protocol = "";
    private String version = "";
    private String host;
    private int port;
    private String nameService;
    private List<String> namePath;

    public CorbanameURL(String host, int port, String namePath, String nameService) {
        this.host = host == null ? DEFAULT_HOST : host;
        this.port = port <= 0 ? DEFAULT_PORT : port;
        this.namePath = CorbanameURL.parseName(namePath);
        this.nameService = nameService == null ? DEFAULT_NAME_SERVICE : nameService;
    }

    public CorbanameURL(String host, int port, String namePath) {
        this(host, port, namePath, DEFAULT_NAME_SERVICE);
    }

    public CorbanameURL(String url) {
        if (url == null || !url.startsWith("corbaname")) {
            throw new IllegalArgumentException("Malformed corbaname URL: " + url);
        }
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        String[] parts = url.split("#");
        if (parts.length == 2) {
            String serviceLocation = parts[0];
            String servicePath = parts[1];
            this.namePath = CorbanameURL.parseName(servicePath);
            parts = serviceLocation.split("/");
            this.nameService = parts.length == 2 ? parts[1] : DEFAULT_NAME_SERVICE;
            if ((parts = parts[0].split(":")).length >= 2) {
                this.protocol = parts[1];
            }
            if (parts.length >= 3) {
                this.version = parts[2];
                String[] strs = this.version.split("@");
                if (strs.length == 2) {
                    this.version = strs[0];
                    this.host = strs[1];
                } else {
                    this.version = "";
                    this.host = strs[0];
                }
            }
            if (this.host == null || "".equals(this.host)) {
                this.host = DEFAULT_HOST;
            }
            this.port = parts.length >= 4 && !"".equals(parts[3]) ? Integer.parseInt(parts[3]) : DEFAULT_PORT;
        } else {
            throw new IllegalArgumentException("Malformed corbaname URL: " + url);
        }
    }

    private static List<String> parseName(String name) {
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        String[] names = name.split("/");
        return Arrays.asList(names);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getNameService() {
        return this.nameService;
    }

    public void setNameService(String nameService) {
        this.nameService = nameService;
    }

    public List<String> getNamePath() {
        return this.namePath;
    }

    public String getName() {
        if (this.namePath != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.namePath.size(); ++i) {
                buf.append(this.namePath.get(i));
                if (i >= this.namePath.size() - 1) continue;
                buf.append("/");
            }
            return buf.toString();
        }
        return null;
    }

    public void setNamePath(List<String> namePath) {
        this.namePath = namePath;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("corbaname:");
        buf.append(this.protocol).append(":");
        if (this.version != null && !"".equals(this.version)) {
            buf.append(this.version).append("@");
        }
        buf.append(this.host).append(":").append(this.port);
        buf.append("/").append(this.nameService);
        buf.append("#");
        if (this.namePath != null) {
            for (int i = 0; i < this.namePath.size(); ++i) {
                buf.append(this.namePath.get(i));
                if (i >= this.namePath.size() - 1) continue;
                buf.append("/");
            }
        }
        return buf.toString();
    }
}

