/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.utils;

import java.lang.reflect.Method;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.extension.helper.utils.DynamicImplementation;
import org.apache.tuscany.sca.interfacedef.impl.InterfaceContractImpl;
import org.apache.tuscany.sca.interfacedef.impl.InterfaceImpl;
import org.apache.tuscany.sca.interfacedef.impl.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStAXArtifactProcessor<I extends Implementation>
implements StAXArtifactProcessor<I> {
    protected AssemblyFactory assemblyFactory;

    public AbstractStAXArtifactProcessor(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    @Override
    public void resolve(I model, ModelResolver resolver) throws ContributionResolveException {
        this.addSideFileComponentType(model.getURI(), (Implementation)model, resolver);
        if (model instanceof DynamicImplementation && model.getServices().size() < 1) {
            Service dynamicService = this.createDynamicService();
            model.getServices().add(dynamicService);
        }
        try {
            Method resolveMethod = model.getClass().getMethod("resolve", ModelResolver.class);
            if (resolveMethod != null) {
                resolveMethod.invoke(model, resolver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        model.setUnresolved(false);
    }

    protected void addSideFileComponentType(String name, Implementation impl, ModelResolver resolver) {
        if (name == null) {
            return;
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return;
        }
        String sideFileName = name.substring(0, lastDot) + ".componentType";
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setURI(sideFileName);
        componentType.setUnresolved(true);
        componentType = resolver.resolveModel(ComponentType.class, componentType);
        if (!componentType.isUnresolved()) {
            for (Reference reference : componentType.getReferences()) {
                impl.getReferences().add(reference);
            }
            for (Service service : componentType.getServices()) {
                impl.getServices().add(service);
            }
            for (Property property : componentType.getProperties()) {
                impl.getProperties().add(property);
            }
            if (componentType.getConstrainingType() != null) {
                impl.setConstrainingType(componentType.getConstrainingType());
            }
        }
    }

    protected Service createDynamicService() {
        Service dynamicService = this.assemblyFactory.createService();
        dynamicService.setName("$dynamic$");
        InterfaceContractImpl dynamicInterfaceContract = new InterfaceContractImpl(){};
        DynamicInterfaceImpl dynamicInterface = new DynamicInterfaceImpl();
        OperationImpl dynamicOperation = new OperationImpl();
        dynamicOperation.setDynamic(true);
        dynamicInterface.getOperations().add(dynamicOperation);
        dynamicInterfaceContract.setInterface(dynamicInterface);
        dynamicService.setInterfaceContract(dynamicInterfaceContract);
        return dynamicService;
    }

    private static class DynamicInterfaceImpl
    extends InterfaceImpl {
        private DynamicInterfaceImpl() {
        }

        public boolean isDynamic() {
            return true;
        }
    }
}

