/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImplementation
implements Implementation {
    private List<Service> services = new ArrayList<Service>();
    private List<Reference> references = new ArrayList<Reference>();
    private List<Property> properties = new ArrayList<Property>();
    private ConstrainingType constrainingType;
    private String uri;
    private boolean unresolved = true;
    private List<ConfiguredOperation> configuredOperations = new ArrayList<ConfiguredOperation>();
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<Intent> requiredIntents = new ArrayList<Intent>();
    private IntentAttachPointType type = null;

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public ConstrainingType getConstrainingType() {
        return this.constrainingType;
    }

    @Override
    public void setConstrainingType(ConstrainingType constrainingType) {
        this.constrainingType = constrainingType;
    }

    public List<Object> getExtensions() {
        return null;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    public Service getService(String name) {
        for (Service service : this.getServices()) {
            if (!service.getName().equals(name)) continue;
            return service;
        }
        return null;
    }

    public Reference getReference(String name) {
        for (Reference reference : this.getReferences()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        return null;
    }

    public Property getProptery(String name) {
        for (Property property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public List<ConfiguredOperation> getConfiguredOperations() {
        return this.configuredOperations;
    }

    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    public List<Intent> getRequiredIntents() {
        return this.requiredIntents;
    }

    public IntentAttachPointType getType() {
        return this.type;
    }

    public void setType(IntentAttachPointType type) {
        this.type = type;
    }
}

