/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extension.helper.impl.PojoImplementation;
import org.apache.tuscany.sca.extension.helper.utils.AbstractStAXArtifactProcessor;
import org.apache.tuscany.sca.extension.helper.utils.DynamicImplementation;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCDLProcessor
extends AbstractStAXArtifactProcessor<Implementation> {
    protected QName scdlQName;
    protected Class<Implementation> implementationClass;
    protected ExtensionPointRegistry registry;
    protected ModelFactoryExtensionPoint factories;
    protected Map<String, Method> attributeSetters;
    protected Method elementTextSetter;

    public SCDLProcessor(AssemblyFactory assemblyFactory, QName scdlQName, Class<Implementation> implementationClass, ExtensionPointRegistry registry, ModelFactoryExtensionPoint factories) {
        super(assemblyFactory);
        this.scdlQName = scdlQName;
        this.implementationClass = implementationClass;
        this.registry = registry;
        this.factories = factories;
        this.initAttributes();
    }

    protected void initAttributes() {
        this.attributeSetters = new HashMap<String, Method>();
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(this.implementationClass.getMethods()));
        methods.removeAll(Arrays.asList(DynamicImplementation.class.getMethods()));
        for (Method m : methods) {
            if ("setElementText".equals(m.getName())) {
                this.elementTextSetter = m;
                continue;
            }
            if (!m.getName().startsWith("set")) continue;
            this.attributeSetters.put(this.getFieldName(m), m);
        }
    }

    protected String getFieldName(Method m) {
        StringBuilder sb = new StringBuilder(m.getName().substring(3));
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        String name = sb.toString();
        if (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private Object[] getImplConstrArgs() {
        Constructor<?>[] cs = this.implementationClass.getConstructors();
        if (cs.length != 1) {
            throw new IllegalArgumentException("Implementation class must have a single constructor: " + this.implementationClass.getName());
        }
        ArrayList args = new ArrayList();
        for (Class<?> c : cs[0].getParameterTypes()) {
            Object o = this.factories.getFactory(c);
            if (o == null) {
                o = this.registry.getExtensionPoint(c);
            }
            args.add(o);
        }
        return args.toArray();
    }

    @Override
    public QName getArtifactType() {
        return this.scdlQName;
    }

    @Override
    public Class<Implementation> getModelType() {
        Class clazz = Implementation.class.isAssignableFrom(this.implementationClass) ? this.implementationClass : PojoImplementation.class;
        return clazz;
    }

    @Override
    public Implementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        Object impl;
        try {
            impl = this.implementationClass.getConstructors()[0].newInstance(this.getImplConstrArgs());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String attribute : this.attributeSetters.keySet()) {
            String value = reader.getAttributeValue(null, attribute);
            if (value == null || value.length() <= 0) continue;
            try {
                this.attributeSetters.get(attribute).invoke(impl, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.elementTextSetter != null) {
            try {
                String value = reader.getElementText();
                if (value != null && value.length() > 0) {
                    this.elementTextSetter.invoke(impl, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        while ((reader.getEventType() != 2 || !this.scdlQName.equals(reader.getName())) && reader.hasNext()) {
            reader.next();
        }
        if (!(impl instanceof Implementation)) {
            impl = new PojoImplementation(impl);
        }
        return (Implementation)impl;
    }

    @Override
    public void write(Implementation arg0, XMLStreamWriter arg1) throws ContributionWriteException, XMLStreamException {
    }

    @Override
    protected void addSideFileComponentType(String name, Implementation impl, ModelResolver resolver) {
        ComponentType componentType;
        try {
            componentType = this.getComponentType(resolver, impl);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        if (componentType != null && !componentType.isUnresolved()) {
            for (Reference reference : componentType.getReferences()) {
                impl.getReferences().add(reference);
            }
            for (Service service : componentType.getServices()) {
                impl.getServices().add(service);
            }
            for (Property property : componentType.getProperties()) {
                impl.getProperties().add(property);
            }
            if (componentType.getConstrainingType() != null) {
                impl.setConstrainingType(componentType.getConstrainingType());
            }
        }
    }

    ComponentType getComponentType(ModelResolver resolver, Implementation impl) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Method m : this.getGetters()) {
            Object io;
            String value = (String)m.invoke(io = impl instanceof PojoImplementation ? ((PojoImplementation)impl).getUserImpl() : impl, new Object[0]);
            if (value == null) continue;
            value = value.substring(0, value.lastIndexOf(46));
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setUnresolved(true);
            componentType.setURI(value + ".componentType");
            if ((componentType = resolver.resolveModel(ComponentType.class, componentType)).isUnresolved()) continue;
            return componentType;
        }
        return null;
    }

    private List<Method> getGetters() {
        ArrayList<Method> ms = new ArrayList<Method>();
        for (Method setter : this.attributeSetters.values()) {
            String s = this.getFieldName(setter);
            for (Method m : this.implementationClass.getMethods()) {
                String name = m.getName();
                if (name.length() <= 3 || !name.startsWith("get") || !s.endsWith(name.substring(4))) continue;
                ms.add(m);
            }
        }
        return ms;
    }
}

