/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryUtils {
    public static <T> List<T> discoverActivators(Class<T> activatorClass, ExtensionPointRegistry registry) {
        ArrayList activators;
        try {
            Set<ServiceDeclaration> activatorClasses = ServiceDiscovery.getInstance().getServiceDeclarations(activatorClass);
            activators = new ArrayList();
            for (ServiceDeclaration declaration : activatorClasses) {
                try {
                    Class<?> c = declaration.loadClass();
                    activators.add(c.cast(DiscoveryUtils.instantiateActivator(c, registry)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return activators;
    }

    static Object instantiateActivator(Class activator, ExtensionPointRegistry registry) {
        Constructor<?>[] cs = activator.getConstructors();
        if (cs.length != 1) {
            throw new RuntimeException("Activator must have only one constructors");
        }
        Class<?>[] paramTypes = cs[0].getParameterTypes();
        Object[] extensions = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            extensions[i] = "org.apache.tuscany.sca.host.http.ServletHost".equals(paramTypes[i].getName()) ? DiscoveryUtils.getServletHost(registry) : registry.getExtensionPoint(paramTypes[i]);
        }
        try {
            return cs[0].newInstance(extensions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getServletHost(ExtensionPointRegistry registry) {
        try {
            Class<?> servletHostEPClass = Class.forName("org.apache.tuscany.sca.host.http.ServletHostExtensionPoint");
            Object servletHostEP = registry.getExtensionPoint(servletHostEPClass);
            Class<?> extensibleServletHost = Class.forName("org.apache.tuscany.sca.host.http.ExtensibleServletHost");
            return extensibleServletHost.getConstructor(servletHostEPClass).newInstance(servletHostEP);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

