/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extension.helper.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.extension.helper.impl.PojoBinding;
import org.apache.tuscany.sca.extension.helper.utils.AbstractBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingSCDLProcessor
implements StAXArtifactProcessor {
    protected QName scdlQName;
    protected Class<Binding> bindingClass;
    protected Map<String, Method> attributeSetters;
    protected Method elementTextSetter;

    public BindingSCDLProcessor(QName scdlQName, Class<Binding> implementationClass) {
        this.scdlQName = scdlQName;
        this.bindingClass = implementationClass;
        this.initAttributes();
    }

    protected void initAttributes() {
        this.attributeSetters = new HashMap<String, Method>();
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(this.bindingClass.getMethods()));
        methods.removeAll(Arrays.asList(AbstractBinding.class.getMethods()));
        for (Method m : methods) {
            if ("setElementText".equals(m.getName())) {
                this.elementTextSetter = m;
                continue;
            }
            if (!m.getName().startsWith("set")) continue;
            this.attributeSetters.put(this.getFieldName(m), m);
        }
    }

    protected String getFieldName(Method m) {
        StringBuilder sb = new StringBuilder(m.getName().substring(3));
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        String name = sb.toString();
        if (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    @Override
    public QName getArtifactType() {
        return this.scdlQName;
    }

    @Override
    public Class getModelType() {
        return PojoBinding.class;
    }

    public Binding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        Binding impl;
        try {
            impl = this.bindingClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String attribute : this.attributeSetters.keySet()) {
            String value = reader.getAttributeValue(null, attribute);
            if (value == null || value.length() <= 0) continue;
            try {
                this.attributeSetters.get(attribute).invoke((Object)impl, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String uri = reader.getAttributeValue(null, "uri");
        if (this.elementTextSetter != null) {
            try {
                String value = reader.getElementText();
                if (value != null && value.length() > 0) {
                    this.elementTextSetter.invoke((Object)impl, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        while ((reader.getEventType() != 2 || !this.scdlQName.equals(reader.getName())) && reader.hasNext()) {
            reader.next();
        }
        if (!(impl instanceof Binding)) {
            impl = new PojoBinding(impl);
            if (uri != null) {
                ((PojoBinding)impl).setURI(uri);
            }
        }
        return impl;
    }

    @Override
    public void resolve(Object model, ModelResolver resolver) throws ContributionResolveException {
    }

    public void write(Object model, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String uri;
        String prefix = writer.getPrefix(this.scdlQName.getNamespaceURI());
        if (prefix == null) {
            NamespaceContext nsc = writer.getNamespaceContext();
            int i = 1;
            while (nsc.getNamespaceURI(prefix = "ns" + i) != null) {
                ++i;
            }
            writer.setPrefix(prefix, this.scdlQName.getNamespaceURI());
        }
        writer.writeStartElement(this.scdlQName.getNamespaceURI(), this.scdlQName.getLocalPart());
        try {
            uri = (String)model.getClass().getMethod("getURI", new Class[0]).invoke(model, new Object[0]);
        }
        catch (Exception e) {
            uri = null;
        }
        if (uri != null) {
            writer.writeAttribute("uri", uri);
        }
        writer.writeEndElement();
    }
}

