/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscoverer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextClassLoaderServiceDiscoverer
implements ServiceDiscoverer {
    private static final Logger logger = Logger.getLogger(ContextClassLoaderServiceDiscoverer.class.getName());
    private WeakReference<ClassLoader> classLoaderReference;

    public ContextClassLoaderServiceDiscoverer() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.classLoaderReference = new WeakReference<ClassLoader>(classLoader);
    }

    private List<URL> getResources(final String name, final boolean firstOnly) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<List<URL>>(){

                @Override
                public List<URL> run() throws IOException {
                    if (firstOnly) {
                        URL url = ((ClassLoader)ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get()).getResource(name);
                        if (url != null) {
                            return Arrays.asList(url);
                        }
                        return Collections.emptyList();
                    }
                    ArrayList<URL> urls = Collections.list(((ClassLoader)ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get()).getResources(name));
                    return urls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static Map<String, String> parseServiceDeclaration(String declaration) {
        String value;
        String key;
        HashMap<String, String> attributes = new HashMap<String, String>();
        int index = declaration.indexOf(59);
        if (index != -1) {
            attributes.put("class", declaration.substring(0, index).trim());
            declaration = declaration.substring(index);
        } else {
            int j = declaration.indexOf(61);
            if (j == -1) {
                attributes.put("class", declaration.trim());
                return attributes;
            }
            declaration = ";" + declaration;
        }
        StringTokenizer tokens = new StringTokenizer(declaration);
        while (tokens.hasMoreTokens() && (key = tokens.nextToken("=").substring(1).trim()) != null && (value = tokens.nextToken(",").substring(1).trim()) != null) {
            attributes.put(key, value);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<ServiceDeclaration> discover(String serviceName, boolean firstOnly) {
        HashSet<ServiceDeclaration> descriptors = new HashSet<ServiceDeclaration>();
        String name = "META-INF/services/" + serviceName;
        boolean debug = logger.isLoggable(Level.FINE);
        try {
            Iterator<URL> i$ = this.getResources(name, firstOnly).iterator();
            block14: while (i$.hasNext()) {
                InputStream is;
                final URL url = i$.next();
                if (debug) {
                    logger.fine("Reading service provider file: " + url.toExternalForm());
                }
                try {
                    is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            URLConnection connection = url.openConnection();
                            connection.setDefaultUseCaches(false);
                            connection.setUseCaches(false);
                            return url.openStream();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is));
                    int count = 0;
                    while (true) {
                        Map<String, String> attributes;
                        String className;
                        String line;
                        if ((line = reader.readLine()) == null) continue block14;
                        if ((line = line.trim()).startsWith("#") || "".equals(line)) continue;
                        String reg = line.trim();
                        if (debug) {
                            logger.fine("Registering service provider: " + reg);
                        }
                        if ((className = (attributes = ContextClassLoaderServiceDiscoverer.parseServiceDeclaration(reg)).get("class")) == null) {
                            className = "_class_" + count;
                            ++count;
                        }
                        ServiceDeclarationImpl descriptor = new ServiceDeclarationImpl(url, className, attributes);
                        descriptors.add(descriptor);
                        if (firstOnly) break;
                    }
                    HashSet<ServiceDeclaration> hashSet = descriptors;
                    return hashSet;
                }
                finally {
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            return descriptors;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return descriptors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServiceDeclarationImpl
    implements ServiceDeclaration {
        private URL url;
        private String className;
        private Class<?> javaClass;
        private Map<String, String> attributes;

        public ServiceDeclarationImpl(URL url, String className, Map<String, String> attributes) {
            this.url = url;
            this.className = className;
            this.attributes = attributes;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public URL getLocation() {
            return this.url;
        }

        @Override
        public Class<?> loadClass() throws ClassNotFoundException {
            if (this.className == null) {
                return null;
            }
            if (this.javaClass == null) {
                this.javaClass = this.loadClass(this.className);
            }
            return this.javaClass;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            return ((ClassLoader)ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get()).loadClass(className);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ClassLoader: ").append(ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get());
            sb.append(" Attributes: ").append(this.attributes);
            return sb.toString();
        }

        @Override
        public URL getResource(final String name) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return ((ClassLoader)ContextClassLoaderServiceDiscoverer.this.classLoaderReference.get()).getResource(name);
                }
            });
        }
    }
}

