/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(interfaces={Servlet.class})
public class QuickStartServiceImpl
extends HttpServlet {
    private static final long serialVersionUID = -3477992129462720901L;
    private static final Logger logger = Logger.getLogger(QuickStartServiceImpl.class.getName());
    @Reference
    public LocalItemCollection contributionCollection;
    @Reference
    public LocalItemCollection deployableCollection;
    @Reference
    public LocalItemCollection domainCompositeCollection;
    @Reference
    public LocalItemCollection cloudCollection;
    @Reference
    public LocalItemCollection processCollection;

    @Init
    public void initialize() throws ParserConfigurationException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Entry<K, D>[] deployableEntries;
            String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String contributionURI = request.getParameter("contribution");
            String contributionLocation = request.getParameter("location");
            String compositeURI = request.getParameter("composite");
            String start = request.getParameter("start");
            logger.fine("Composite Quick Start.");
            logger.fine("Contribution URI: " + contributionURI);
            logger.fine("Contribution location: " + contributionLocation);
            logger.fine("Composite URI: " + compositeURI);
            Entry<K, D>[] contributionEntries = this.contributionCollection.getAll();
            Entry contributionEntry = null;
            for (Entry entry : contributionEntries) {
                if (!contributionURI.equals(entry.getKey())) continue;
                contributionEntry = entry;
                break;
            }
            if (contributionEntry == null) {
                Item item = new Item();
                item.setLink(contributionLocation);
                this.contributionCollection.post(contributionURI, item);
            }
            String compositeKey = null;
            for (Entry entry : deployableEntries = this.deployableCollection.query("contribution=" + contributionURI)) {
                Item item = (Item)entry.getData();
                if (!contributionURI.equals(DomainManagerUtil.contributionURI((String)entry.getKey())) || !item.getAlternate().endsWith(compositeURI)) continue;
                compositeKey = (String)entry.getKey();
                break;
            }
            if (compositeKey == null) {
                response.sendError(404, compositeURI);
                return;
            }
            try {
                this.domainCompositeCollection.get(compositeKey);
            }
            catch (NotFoundException e) {
                Item item = new Item();
                this.domainCompositeCollection.post(compositeKey, item);
            }
            Entry<K, D>[] nodeEntries = this.cloudCollection.getAll();
            String nodeName = null;
            for (Entry entry : nodeEntries) {
                int c;
                Item item = (Item)entry.getData();
                String related = item.getRelated();
                if (related == null || !compositeKey.equals(related = related.substring(c = related.indexOf("composite:")))) continue;
                nodeName = DomainManagerUtil.compositeQName((String)entry.getKey()).getLocalPart();
            }
            if (nodeName == null) {
                QName compositeName = DomainManagerUtil.compositeQName(compositeKey);
                nodeName = compositeName.getLocalPart() + "Node";
                String nodeKey = DomainManagerUtil.compositeKey("http://tuscany.apache.org/cloud", new QName("http://tuscany.apache.org/cloud", nodeName));
                HashSet<Integer> nodePorts = new HashSet<Integer>();
                for (Entry entry : nodeEntries) {
                    URI u;
                    int port;
                    Item item = (Item)entry.getData();
                    String uri = DomainManagerUtil.nodeURI(item.getContents());
                    if (uri == null || (port = (u = URI.create(uri)).getPort()) == -1) continue;
                    nodePorts.add(port);
                }
                String nodeURI = null;
                for (int port = 8100; port < 8200; ++port) {
                    if (nodePorts.contains(port)) continue;
                    nodeURI = "http://localhost:" + port;
                    break;
                }
                if (nodeURI == null) {
                    throw new RuntimeException("Couldn't find a free port for new node: " + nodeName);
                }
                Item item = new Item();
                String content = "<composite xmlns=\"http://www.osoa.org/xmlns/sca/1.0\"\n       xmlns:t=\"http://tuscany.apache.org/xmlns/sca/1.0\"\n       targetNamespace=\"http://tuscany.apache.org/cloud\"\n       xmlns:c=\"" + compositeName.getNamespaceURI() + "\"\n" + "       name=\"" + nodeName + "\">\n" + "\n" + "       <component name=\"" + nodeName + "\">\n" + "               <t:implementation.node uri=\"" + contributionURI + "\" composite=\"c:" + compositeName.getLocalPart() + "\"/>\n" + "               <service name=\"Node\">\n" + "                       <binding.ws uri=\"" + nodeURI + "\"/>\n" + "                       <t:binding.http uri=\"" + nodeURI + "\"/>\n" + "                       <t:binding.jsonrpc uri=\"" + nodeURI + "\"/>\n" + "                       <t:binding.atom uri=\"" + nodeURI + "\"/>\n" + "               </service>\n" + "       </component>\n" + "</composite>";
                item.setContents(content);
                this.cloudCollection.post(nodeKey, item);
            }
            if ("true".equals(start)) {
                this.processCollection.post(nodeName, new Item());
            }
            response.getWriter().print("<html><body>Node <span id=\"node\">" + nodeName + "</span> OK.</body></html>");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not start composite", e);
            response.sendError(500, e.toString());
        }
    }
}

