/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.binding.atom.AtomBindingFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.osoa.sca.ServiceRuntimeException;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(interfaces={ItemCollection.class, LocalItemCollection.class})
public class NodeProcessCollectionFacadeImpl
implements ItemCollection,
LocalItemCollection {
    private static final Logger logger = Logger.getLogger(NodeProcessCollectionFacadeImpl.class.getName());
    @Reference
    public LocalItemCollection cloudCollection;
    @Reference
    public ItemCollection processCollection;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    private AssemblyFactory assemblyFactory;
    private AtomBindingFactory atomBindingFactory;
    private CompositeActivator compositeActivator;

    @Init
    public void initialize() {
        ExtensionPointRegistry extensionPoints = this.domainManagerConfiguration.getExtensionPoints();
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.atomBindingFactory = modelFactories.getFactory(AtomBindingFactory.class);
    }

    @Override
    public Entry<String, Item>[] getAll() {
        logger.fine("getAll");
        Entry<K, D>[] nodeEntries = this.cloudCollection.getAll();
        ArrayList entries = new ArrayList();
        Iterator<String> i$ = NodeProcessCollectionFacadeImpl.hosts(nodeEntries).iterator();
        if (i$.hasNext()) {
            String host = i$.next();
            ItemCollection processCollection = this.processCollection(host);
            for (Entry remoteEntry : processCollection.getAll()) {
                entries.add(remoteEntry);
            }
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    @Override
    public Item get(String key) throws NotFoundException {
        logger.fine("get " + key);
        String host = this.host(key);
        ItemCollection processCollection = this.processCollection(host);
        return (Item)processCollection.get(key);
    }

    @Override
    public String post(String key, Item item) {
        String host;
        logger.fine("post " + key);
        try {
            host = this.host(key);
        }
        catch (NotFoundException e) {
            throw new ServiceRuntimeException(e);
        }
        ItemCollection processCollection = this.processCollection(host);
        return processCollection.post(key, item);
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String key) throws NotFoundException {
        logger.fine("delete " + key);
        String host = this.host(key);
        ItemCollection processCollection = this.processCollection(host);
        processCollection.delete(key);
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        logger.fine("query " + queryString);
        if (queryString.startsWith("node=")) {
            String host;
            String key = queryString.substring(queryString.indexOf(61) + 1);
            try {
                host = this.host(key);
            }
            catch (NotFoundException e) {
                return new Entry[0];
            }
            ItemCollection processCollection = this.processCollection(host);
            return processCollection.query(queryString);
        }
        throw new UnsupportedOperationException();
    }

    private String host(String nodeName) throws NotFoundException {
        Entry<String, Item> nodeEntry = NodeProcessCollectionFacadeImpl.nodeEntry(this.cloudCollection.getAll(), nodeName);
        if (nodeEntry == null) {
            throw new NotFoundException(nodeName);
        }
        return NodeProcessCollectionFacadeImpl.host(nodeEntry.getData());
    }

    private static Entry<String, Item> nodeEntry(Entry<String, Item>[] entries, String name) {
        for (Entry<String, Item> entry : entries) {
            QName qname = DomainManagerUtil.compositeQName(entry.getKey());
            if (!qname.getLocalPart().equals(name)) continue;
            return entry;
        }
        return null;
    }

    private static List<String> hosts(Entry<String, Item>[] entries) {
        ArrayList<String> hosts = new ArrayList<String>();
        for (Entry<String, Item> entry : entries) {
            String host = NodeProcessCollectionFacadeImpl.host(entry.getData());
            if (hosts.contains(host)) continue;
            hosts.add(host);
        }
        return hosts;
    }

    private static String host(Item item) {
        String uri = DomainManagerUtil.nodeURI(item.getContents());
        if (uri != null) {
            return URI.create(uri).getHost();
        }
        return null;
    }

    private ItemCollection processCollection(String host) {
        return this.processCollection;
    }
}

