/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(value=Servlet.class)
public class NodeConfigurationServiceImpl
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 6913769467386954463L;
    private static final Logger logger = Logger.getLogger(NodeConfigurationServiceImpl.class.getName());
    @Reference
    public LocalItemCollection contributionCollection;
    @Reference
    public LocalItemCollection cloudCollection;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Entry<K, D>[] cloudEntries;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        String key = path.startsWith("/") ? path.substring(1) : path;
        logger.fine("get " + key);
        for (Entry cloudEntry : cloudEntries = this.cloudCollection.getAll()) {
            String related;
            int i;
            QName qname = DomainManagerUtil.compositeQName((String)cloudEntry.getKey());
            if (!qname.getLocalPart().equals(key) || (i = (related = ((Item)cloudEntry.getData()).getRelated()).indexOf("composite:")) == -1) continue;
            String compositeConfiguration = "/composite-config/?composite=" + related.substring(i);
            response.sendRedirect(compositeConfiguration);
            return;
        }
        response.sendError(404, key);
    }
}

