/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(value=ItemCollection.class)
public class FileCollectionImpl
implements ItemCollection {
    private static final Logger logger = Logger.getLogger(FileCollectionImpl.class.getName());
    @Property
    public String directoryName;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;

    @Init
    public void initialize() throws IOException {
    }

    @Override
    public Entry<String, Item>[] getAll() {
        logger.fine("getAll");
        String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
        ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
        File directory = new File(rootDirectory + "/" + this.directoryName);
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.getName().startsWith(".")) continue;
                entries.add(FileCollectionImpl.entry(file.getName()));
            }
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    @Override
    public Item get(String key) throws NotFoundException {
        logger.fine("get " + key);
        return FileCollectionImpl.item(key);
    }

    @Override
    public String post(String key, Item item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String key) throws NotFoundException {
        logger.fine("delete " + key);
        String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
        File directory = new File(rootDirectory + "/" + this.directoryName);
        File file = new File(directory, key);
        if (!file.exists()) {
            throw new NotFoundException(key);
        }
        file.delete();
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        throw new UnsupportedOperationException();
    }

    private static Entry<String, Item> entry(String fileName) {
        Entry<String, Item> entry = new Entry<String, Item>();
        entry.setKey(fileName);
        entry.setData(FileCollectionImpl.item(fileName));
        return entry;
    }

    private static Item item(String fileName) {
        Item item = new Item();
        item.setTitle(fileName);
        item.setLink("/files/" + fileName);
        return item;
    }
}

