/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.context.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomainManagerUtil {
    static final String DEPLOYMENT_CONTRIBUTION_URI = "http://tuscany.apache.org/cloud";

    static QName compositeQName(String key) {
        int i = key.indexOf(59);
        key = key.substring(i + 1);
        i = key.indexOf(59);
        return new QName(key.substring(0, i), key.substring(i + 1));
    }

    static String compositeTitle(String uri, QName qname) {
        if (uri.equals(DEPLOYMENT_CONTRIBUTION_URI)) {
            return qname.getLocalPart();
        }
        return uri + " - " + qname.getNamespaceURI() + ";" + qname.getLocalPart();
    }

    static String contributionURI(String key) {
        int i = key.indexOf(59);
        return key.substring("composite:".length(), i);
    }

    static String compositeKey(String uri, QName qname) {
        return "composite:" + uri + ';' + qname.getNamespaceURI() + ';' + qname.getLocalPart();
    }

    static String compositeSourceLink(String contributionURI, QName qname) {
        return "/composite-source/" + DomainManagerUtil.compositeKey(contributionURI, qname);
    }

    static String compositeSimpleTitle(String uri, QName qname) {
        if (uri.equals(DEPLOYMENT_CONTRIBUTION_URI)) {
            return qname.getLocalPart();
        }
        return qname.getNamespaceURI() + ";" + qname.getLocalPart();
    }

    static URL locationURL(String location) throws MalformedURLException {
        String scheme = null;
        URI uri = null;
        IllegalArgumentException uriException = null;
        try {
            uri = URI.create(location);
            scheme = uri.getScheme();
        }
        catch (IllegalArgumentException e) {
            uriException = e;
        }
        if (scheme == null) {
            File file = new File(location);
            return file.toURI().toURL();
        }
        if (scheme.equals("file")) {
            File file = new File(location.substring(5));
            return file.toURI().toURL();
        }
        if (uri == null) {
            throw uriException;
        }
        return uri.toURL();
    }

    static String compositeAlternateLink(String contributionLocation, String deployableURI) {
        String path;
        File file;
        if (deployableURI == null) {
            return null;
        }
        URI u = URI.create(contributionLocation);
        String uri = "file".equals(u.getScheme()) ? ((file = new File(path = u.toString().substring(5))).isDirectory() ? (contributionLocation.endsWith("/") ? contributionLocation + deployableURI : contributionLocation + "/" + deployableURI) : contributionLocation + "!/" + deployableURI) : contributionLocation + "!/" + deployableURI;
        int e = uri.indexOf("!/");
        if (e != -1) {
            int s = uri.lastIndexOf(47, e - 2) + 1;
            uri = uri.substring(s, e).contains(".") ? "jar:" + uri : uri.substring(0, e) + uri.substring(e + 1);
        }
        return uri;
    }

    static String nodeURI(String content) {
        int es;
        int bs;
        if (content != null && (bs = content.indexOf("<span id=\"nodeURI\">")) != -1 && (es = (content = content.substring(bs + 19)).indexOf("</span>")) != -1) {
            return content.substring(0, es);
        }
        return null;
    }

    static <B> ServiceReference<B> dynamicReference(Class<B> businessInterface, Binding binding, AssemblyFactory assemblyFactory, CompositeActivator compositeActivator) {
        try {
            Composite composite = assemblyFactory.createComposite();
            composite.setName(new QName("http://tempuri.org", "default"));
            RuntimeComponent component = (RuntimeComponent)assemblyFactory.createComponent();
            component.setName("default");
            component.setURI("default");
            compositeActivator.configureComponentContext(component);
            composite.getComponents().add(component);
            RuntimeComponentReference reference = (RuntimeComponentReference)assemblyFactory.createComponentReference();
            reference.setName("default");
            JavaInterfaceFactory javaInterfaceFactory = compositeActivator.getJavaInterfaceFactory();
            JavaInterfaceContract interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
            interfaceContract.setInterface(javaInterfaceFactory.createJavaInterface(businessInterface));
            reference.setInterfaceContract(interfaceContract);
            component.getReferences().add(reference);
            reference.setComponent(component);
            reference.getBindings().add(binding);
            ProxyFactory proxyFactory = compositeActivator.getProxyFactory();
            return new ServiceReferenceImpl<B>(businessInterface, component, reference, binding, proxyFactory, compositeActivator);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    static long lastModified(URL url) throws IOException {
        if (url.getProtocol() == null || "file".equals(url.getProtocol())) {
            return DomainManagerUtil.lastModified(new File(url.getPath()));
        }
        URLConnection connection = url.openConnection();
        long lastModified = connection.getLastModified();
        return lastModified;
    }

    static long lastModified(File file) {
        if (file.isDirectory()) {
            long lastModified = file.lastModified();
            for (File child : file.listFiles()) {
                long m = DomainManagerUtil.lastModified(child);
                if (m <= lastModified) continue;
                lastModified = m;
            }
            return lastModified;
        }
        return file.lastModified();
    }
}

