/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.osoa.sca.annotations.Destroy;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(value=DomainManagerConfiguration.class)
public class DomainManagerConfigurationImpl
implements DomainManagerConfiguration {
    private String rootDirectory = ".";
    private ExtensionPointRegistry extensionPoints;

    @Init
    public void initialize() {
        this.extensionPoints = new DefaultExtensionPointRegistry();
        ModuleActivatorExtensionPoint moduleActivators = this.extensionPoints.getExtensionPoint(ModuleActivatorExtensionPoint.class);
        for (ModuleActivator activator : moduleActivators.getModuleActivators()) {
            try {
                activator.start(this.extensionPoints);
            }
            catch (Exception e) {}
        }
    }

    @Destroy
    public void destroy() {
        ModuleActivatorExtensionPoint moduleActivators = this.extensionPoints.getExtensionPoint(ModuleActivatorExtensionPoint.class);
        for (ModuleActivator activator : moduleActivators.getModuleActivators()) {
            try {
                activator.stop(this.extensionPoints);
            }
            catch (Exception e) {}
        }
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public ExtensionPointRegistry getExtensionPoints() {
        return this.extensionPoints;
    }
}

