/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.osoa.sca.ServiceRuntimeException;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(interfaces={ItemCollection.class, LocalItemCollection.class})
public class DeployedCompositeCollectionImpl
implements ItemCollection,
LocalItemCollection {
    private static final Logger logger = Logger.getLogger(DeployedCompositeCollectionImpl.class.getName());
    @Property
    public String compositeFile;
    @Property
    public String deploymentContributionDirectory;
    @Reference
    public LocalItemCollection deployableCollection;
    @Reference(required=false)
    public LocalItemCollection processCollection;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    private ModelFactoryExtensionPoint modelFactories;
    private AssemblyFactory assemblyFactory;
    private StAXArtifactProcessor<Composite> compositeProcessor;
    private XMLOutputFactory outputFactory;
    private DocumentBuilder documentBuilder;
    private Cache cache = new Cache();

    @Init
    public void initialize() throws ParserConfigurationException {
        ExtensionPointRegistry extensionPoints = this.domainManagerConfiguration.getExtensionPoints();
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.assemblyFactory = this.modelFactories.getFactory(AssemblyFactory.class);
        this.outputFactory = this.modelFactories.getFactory(XMLOutputFactory.class);
        this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        StAXArtifactProcessorExtensionPoint staxProcessors = extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.compositeProcessor = (StAXArtifactProcessor)staxProcessors.getProcessor(Composite.class);
        this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    @Override
    public Entry<String, Item>[] getAll() {
        logger.fine("getAll");
        ArrayList entries = new ArrayList();
        Composite compositeCollection = this.readCompositeCollection();
        for (Composite composite : compositeCollection.getIncludes()) {
            Item item;
            String contributionURI = composite.getURI();
            QName qname = composite.getName();
            String key = DomainManagerUtil.compositeKey(contributionURI, qname);
            try {
                item = (Item)this.deployableCollection.get(key);
            }
            catch (NotFoundException e) {
                item = new Item();
                item.setTitle(DomainManagerUtil.compositeTitle(contributionURI, qname));
                item.setLink(DomainManagerUtil.compositeSourceLink(contributionURI, qname));
                item.setContents("<span id=\"problem\" style=\"color: red\">Problem: Composite not found</span>");
            }
            Entry<String, Item> entry = new Entry<String, Item>();
            entry.setKey(key);
            entry.setData(item);
            entries.add(entry);
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    @Override
    public Item get(String key) throws NotFoundException {
        logger.fine("get " + key);
        String contributionURI = DomainManagerUtil.contributionURI(key);
        QName qname = DomainManagerUtil.compositeQName(key);
        ArrayList entries = new ArrayList();
        Composite compositeCollection = this.readCompositeCollection();
        for (Composite composite : compositeCollection.getIncludes()) {
            if (!contributionURI.equals(composite.getURI()) || !qname.equals(composite.getName())) continue;
            return (Item)this.deployableCollection.get(key);
        }
        throw new NotFoundException(key);
    }

    @Override
    public String post(String key, Item item) {
        logger.fine("post " + key);
        String contributionURI = DomainManagerUtil.contributionURI(key);
        QName qname = DomainManagerUtil.compositeQName(key);
        Composite compositeCollection = this.readCompositeCollection();
        Composite composite = this.assemblyFactory.createComposite();
        composite.setName(qname);
        composite.setURI(contributionURI);
        composite.setUnresolved(true);
        compositeCollection.getIncludes().add(composite);
        if (this.deploymentContributionDirectory != null && item.getContents() != null) {
            String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
            File directory = new File(rootDirectory + "/" + this.deploymentContributionDirectory);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File file = new File(directory, qname.getLocalPart() + ".composite");
            try {
                OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(file));
                w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                w.write(item.getContents());
                ((Writer)w).close();
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(e);
            }
        }
        this.writeCompositeCollection(compositeCollection);
        return key;
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        logger.fine("put " + key);
        String contributionURI = DomainManagerUtil.contributionURI(key);
        QName qname = DomainManagerUtil.compositeQName(key);
        Composite compositeCollection = this.readCompositeCollection();
        Composite newComposite = this.assemblyFactory.createComposite();
        newComposite.setName(qname);
        newComposite.setURI(contributionURI);
        newComposite.setUnresolved(true);
        List<Composite> composites = compositeCollection.getIncludes();
        int n = composites.size();
        for (int i = 0; i < n; ++i) {
            Composite composite = composites.get(i);
            if (!contributionURI.equals(composite.getURI()) || !qname.equals(composite.getName())) continue;
            composites.set(i, newComposite);
            this.writeCompositeCollection(compositeCollection);
            return;
        }
        throw new NotFoundException(key);
    }

    @Override
    public void delete(String key) throws NotFoundException {
        String rootDirectory;
        File file;
        logger.fine("delete " + key);
        String contributionURI = DomainManagerUtil.contributionURI(key);
        QName qname = DomainManagerUtil.compositeQName(key);
        try {
            this.processCollection.delete(qname.getLocalPart());
        }
        catch (Exception e) {
            // empty catch block
        }
        Composite compositeCollection = this.readCompositeCollection();
        List<Composite> composites = compositeCollection.getIncludes();
        Composite deleted = null;
        int n = composites.size();
        for (int i = 0; i < n; ++i) {
            Composite composite = composites.get(i);
            if (!contributionURI.equals(composite.getURI()) || !qname.equals(composite.getName())) continue;
            composites.remove(i);
            deleted = composite;
            this.writeCompositeCollection(compositeCollection);
            break;
        }
        if (this.deploymentContributionDirectory != null && contributionURI.equals("http://tuscany.apache.org/cloud") && (file = new File((rootDirectory = this.domainManagerConfiguration.getRootDirectory()) + "/" + this.deploymentContributionDirectory, qname.getLocalPart() + ".composite")).exists()) {
            file.delete();
        }
        if (deleted == null) {
            throw new NotFoundException(key);
        }
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        throw new UnsupportedOperationException();
    }

    private Composite readCompositeCollection() throws ServiceRuntimeException {
        Composite compositeCollection;
        String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
        File file = new File(rootDirectory + "/" + this.compositeFile);
        if (file.exists()) {
            if (this.cache.compositeCollection != null && file.lastModified() == this.cache.compositeCollectionLastModified) {
                compositeCollection = this.cache.compositeCollection;
            } else {
                XMLInputFactory inputFactory = this.modelFactories.getFactory(XMLInputFactory.class);
                try {
                    FileInputStream is = new FileInputStream(file);
                    XMLStreamReader reader = inputFactory.createXMLStreamReader(is);
                    compositeCollection = this.compositeProcessor.read(reader);
                }
                catch (Exception e) {
                    throw new ServiceRuntimeException(e);
                }
                this.cache.compositeCollectionLastModified = file.lastModified();
                this.cache.compositeCollection = compositeCollection;
            }
        } else {
            compositeCollection = this.assemblyFactory.createComposite();
            int d = this.compositeFile.lastIndexOf(46);
            String name = d != -1 ? this.compositeFile.substring(0, d) : this.compositeFile;
            compositeCollection.setName(new QName("http://tuscany.apache.org/xmlns/sca/1.0", name));
            this.cache.compositeCollectionLastModified = 0L;
            this.cache.compositeCollection = compositeCollection;
        }
        return compositeCollection;
    }

    private void writeCompositeCollection(Composite compositeCollection) {
        try {
            String rootDirectory = this.domainManagerConfiguration.getRootDirectory();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(bos);
            this.compositeProcessor.write(compositeCollection, writer);
            Document document = this.documentBuilder.parse(new ByteArrayInputStream(bos.toByteArray()));
            OutputFormat format = new OutputFormat();
            format.setIndenting(true);
            format.setIndent(2);
            File file = new File(rootDirectory + "/" + this.compositeFile);
            FileOutputStream os = new FileOutputStream(file);
            XMLSerializer serializer = new XMLSerializer((OutputStream)os, format);
            serializer.serialize(document);
            this.cache.compositeCollection = compositeCollection;
            this.cache.compositeCollectionLastModified = file.lastModified();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    static class Cache {
        private Composite compositeCollection;
        private long compositeCollectionLastModified;

        Cache() {
        }
    }
}

