/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(value=Servlet.class)
public class DeployableCompositeServiceImpl
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -3477992129462720902L;
    private static final Logger logger = Logger.getLogger(DeployableCompositeServiceImpl.class.getName());
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    @Reference
    public LocalItemCollection deployableCollection;

    @Init
    public void initialize() throws ParserConfigurationException {
        ExtensionPointRegistry extensionPoints = this.domainManagerConfiguration.getExtensionPoints();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        InputStream is;
        Item item;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        String key = path.startsWith("/") ? path.substring(1) : path;
        logger.fine("get " + key);
        try {
            item = (Item)this.deployableCollection.get(key);
        }
        catch (NotFoundException e) {
            response.sendError(404, key);
            return;
        }
        String uri = item.getAlternate();
        if (uri == null) {
            response.sendRedirect("/composite-generated/" + key);
            return;
        }
        try {
            URLConnection connection = new URL(uri).openConnection();
            connection.setUseCaches(false);
            connection.connect();
            is = connection.getInputStream();
        }
        catch (FileNotFoundException ex) {
            response.sendError(404, key);
            return;
        }
        response.setContentType("text/xml");
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[4096];
        while ((n = is.read(buffer)) >= 0) {
            os.write(buffer, 0, n);
        }
        is.close();
        os.flush();
    }
}

