/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.apache.tuscany.sca.implementation.node.NodeImplementation;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.workspace.builder.ContributionDependencyBuilder;
import org.apache.tuscany.sca.workspace.builder.impl.ContributionDependencyBuilderImpl;
import org.apache.tuscany.sca.workspace.processor.impl.ContributionContentProcessor;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(interfaces={ItemCollection.class, LocalItemCollection.class})
public class DeployableCompositeCollectionImpl
implements ItemCollection,
LocalItemCollection {
    private static final Logger logger = Logger.getLogger(DeployableCompositeCollectionImpl.class.getName());
    @Reference
    public LocalItemCollection contributionCollection;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    private ModelFactoryExtensionPoint modelFactories;
    private ModelResolverExtensionPoint modelResolvers;
    private URLArtifactProcessor<Contribution> contributionProcessor;
    private XMLOutputFactory outputFactory;
    private ContributionDependencyBuilder contributionDependencyBuilder;
    private Monitor monitor;
    private Cache cache = new Cache();

    @Init
    public void initialize() throws ParserConfigurationException {
        ExtensionPointRegistry extensionPoints = this.domainManagerConfiguration.getExtensionPoints();
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = utilities.getUtility(MonitorFactory.class);
        this.monitor = monitorFactory.createMonitor();
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        XMLInputFactory inputFactory = this.modelFactories.getFactory(XMLInputFactory.class);
        this.outputFactory = this.modelFactories.getFactory(XMLOutputFactory.class);
        this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        StAXArtifactProcessorExtensionPoint staxProcessors = extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        ExtensibleStAXArtifactProcessor staxProcessor = new ExtensibleStAXArtifactProcessor(staxProcessors, inputFactory, this.outputFactory, this.monitor);
        URLArtifactProcessorExtensionPoint urlProcessors = extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        ExtensibleURLArtifactProcessor urlProcessor = new ExtensibleURLArtifactProcessor(urlProcessors, this.monitor);
        this.modelResolvers = extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        this.contributionProcessor = new ContributionContentProcessor(this.modelFactories, this.modelResolvers, urlProcessor, staxProcessor, this.monitor);
        this.contributionDependencyBuilder = new ContributionDependencyBuilderImpl(this.monitor);
    }

    @Override
    public Entry<String, Item>[] getAll() {
        Entry<K, D>[] contributionEntries;
        logger.fine("getAll");
        ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
        for (Entry contributionEntry : contributionEntries = this.contributionCollection.getAll()) {
            Contribution contribution;
            Item contributionItem = (Item)contributionEntry.getData();
            try {
                contribution = this.contribution((String)contributionEntry.getKey(), contributionItem.getAlternate());
            }
            catch (ContributionReadException e) {
                continue;
            }
            for (Composite deployable : contribution.getDeployables()) {
                entries.add(DeployableCompositeCollectionImpl.entry(contribution, deployable));
            }
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    @Override
    public Item get(String key) throws NotFoundException {
        Contribution contribution;
        logger.fine("get " + key);
        String contributionURI = DomainManagerUtil.contributionURI(key);
        Item contributionItem = (Item)this.contributionCollection.get(contributionURI);
        try {
            contribution = this.contribution(contributionURI, contributionItem.getAlternate());
        }
        catch (ContributionReadException e) {
            throw new NotFoundException(key);
        }
        QName qname = DomainManagerUtil.compositeQName(key);
        for (Composite deployable : contribution.getDeployables()) {
            if (!qname.equals(deployable.getName())) continue;
            if (deployable.isUnresolved()) {
                throw new NotFoundException(key);
            }
            return DeployableCompositeCollectionImpl.item(contribution, deployable);
        }
        throw new NotFoundException(key);
    }

    @Override
    public String post(String key, Item item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String key) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        logger.fine("query " + queryString);
        if (queryString.startsWith("contribution=")) {
            Contribution contribution;
            Item contributionItem;
            ArrayList<Entry<String, Item>> entries = new ArrayList<Entry<String, Item>>();
            String contributionURI = queryString.substring(queryString.indexOf(61) + 1);
            try {
                contributionItem = (Item)this.contributionCollection.get(contributionURI);
            }
            catch (NotFoundException e) {
                return entries.toArray(new Entry[entries.size()]);
            }
            try {
                contribution = this.contribution(contributionURI, contributionItem.getAlternate());
            }
            catch (ContributionReadException e) {
                return entries.toArray(new Entry[entries.size()]);
            }
            for (Composite deployable : contribution.getDeployables()) {
                entries.add(DeployableCompositeCollectionImpl.entry(contribution, deployable));
            }
            return entries.toArray(new Entry[entries.size()]);
        }
        throw new UnsupportedOperationException();
    }

    private Contribution contribution(String contributionURI, String contributionLocation) throws ContributionReadException {
        try {
            URI uri = URI.create(contributionURI);
            URL location = DomainManagerUtil.locationURL(contributionLocation);
            Cache.ContributionCache contributionCache = (Cache.ContributionCache)this.cache.contributions.get(location);
            long lastModified = DomainManagerUtil.lastModified(location);
            if (contributionCache != null) {
                if (contributionCache.contributionLastModified == lastModified) {
                    return contributionCache.contribution;
                }
                this.cache.contributions.remove(location);
            }
            Contribution contribution = this.contributionProcessor.read(null, uri, location);
            this.contributionProcessor.resolve(contribution, new DefaultModelResolver());
            contributionCache = new Cache.ContributionCache();
            contributionCache.contribution = contribution;
            contributionCache.contributionLastModified = lastModified;
            this.cache.contributions.put(location, contributionCache);
            return contribution;
        }
        catch (ContributionReadException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw new ContributionReadException(e);
        }
        catch (ContributionResolveException e) {
            throw new ContributionReadException(e);
        }
        catch (Throwable e) {
            throw new ContributionReadException(e);
        }
    }

    private static String content(Composite composite) {
        StringBuffer sb = new StringBuffer();
        List<Component> components = composite.getComponents();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            Component component = components.get(i);
            if (component.getImplementation() instanceof NodeImplementation) {
                List<Binding> bindings;
                List<ComponentService> services = component.getServices();
                if (services.isEmpty() || (bindings = services.get(0).getBindings()).isEmpty()) continue;
                sb.append("Node URI: <span id=\"nodeURI\">");
                sb.append(component.getServices().get(0).getBindings().get(0).getURI());
                break;
            }
            if (sb.length() == 0) {
                sb.append("Components: <span id=\"components\">");
            } else {
                sb.append(" ");
            }
            sb.append(component.getName());
        }
        if (sb.length() != 0) {
            sb.append("</span>");
        }
        return sb.toString();
    }

    private static String relatedLink(Composite composite) {
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof NodeImplementation)) continue;
            NodeImplementation nodeImplementation = (NodeImplementation)component.getImplementation();
            Composite deployable = nodeImplementation.getComposite();
            String contributionURI = deployable.getURI();
            QName qname = deployable.getName();
            String key = DomainManagerUtil.compositeKey(contributionURI, qname);
            return "/composite-source/" + key;
        }
        return null;
    }

    private static Entry<String, Item> entry(Contribution contribution, Composite deployable) {
        Entry<String, Item> entry = new Entry<String, Item>();
        entry.setKey(DomainManagerUtil.compositeKey(contribution.getURI(), deployable.getName()));
        entry.setData(DeployableCompositeCollectionImpl.item(contribution, deployable));
        return entry;
    }

    private static Item item(Contribution contribution, Composite deployable) {
        String contributionURI = contribution.getURI();
        String contributionLocation = contribution.getLocation();
        QName qname = deployable.getName();
        String deployableURI = deployable.getURI();
        Item item = new Item();
        item.setTitle(DomainManagerUtil.compositeTitle(contributionURI, qname));
        item.setContents(DeployableCompositeCollectionImpl.content(deployable));
        item.setLink(DomainManagerUtil.compositeSourceLink(contributionURI, qname));
        item.setAlternate(DomainManagerUtil.compositeAlternateLink(contributionLocation, deployableURI));
        item.setRelated(DeployableCompositeCollectionImpl.relatedLink(deployable));
        return item;
    }

    static class Cache {
        private Map<URL, ContributionCache> contributions = new HashMap<URL, ContributionCache>();

        Cache() {
        }

        static class ContributionCache {
            private Contribution contribution;
            private long contributionLastModified;

            ContributionCache() {
            }
        }
    }
}

