/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(interfaces={Servlet.class})
public class ContributionServiceImpl
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -4759297945439322773L;
    private static final Logger logger = Logger.getLogger(ContributionServiceImpl.class.getName());
    @Reference
    public LocalItemCollection contributionCollection;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Item item;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        String key = path.startsWith("/") ? path.substring(1) : path;
        logger.fine("get " + key);
        try {
            item = (Item)this.contributionCollection.get(key);
        }
        catch (NotFoundException e) {
            response.sendError(404, key);
            return;
        }
        response.sendRedirect("/files/" + item.getAlternate());
    }
}

