/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerConfiguration;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.workspace.processor.impl.ContributionContentProcessor;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

@Scope(value="COMPOSITE")
@Service(interfaces={Servlet.class})
public class CompositeGeneratorServiceImpl
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -6531448326726908269L;
    private static final Logger logger = Logger.getLogger(CompositeGeneratorServiceImpl.class.getName());
    @Reference
    public LocalItemCollection contributionCollection;
    @Reference
    public DomainManagerConfiguration domainManagerConfiguration;
    private ModelFactoryExtensionPoint modelFactories;
    private ModelResolverExtensionPoint modelResolvers;
    private URLArtifactProcessor<Contribution> contributionProcessor;
    private StAXArtifactProcessor<Composite> compositeProcessor;
    private XMLOutputFactory outputFactory;
    private Cache cache = new Cache();

    @Init
    public void initialize() throws ParserConfigurationException {
        ExtensionPointRegistry extensionPoints = this.domainManagerConfiguration.getExtensionPoints();
        UtilityExtensionPoint services = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = services.getUtility(MonitorFactory.class);
        Monitor monitor = monitorFactory.createMonitor();
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        XMLInputFactory inputFactory = this.modelFactories.getFactory(XMLInputFactory.class);
        this.outputFactory = this.modelFactories.getFactory(XMLOutputFactory.class);
        this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        StAXArtifactProcessorExtensionPoint staxProcessors = extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.compositeProcessor = (StAXArtifactProcessor)staxProcessors.getProcessor(Composite.class);
        ExtensibleStAXArtifactProcessor staxProcessor = new ExtensibleStAXArtifactProcessor(staxProcessors, inputFactory, this.outputFactory, monitor);
        URLArtifactProcessorExtensionPoint urlProcessors = extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        ExtensibleURLArtifactProcessor urlProcessor = new ExtensibleURLArtifactProcessor(urlProcessors, monitor);
        this.modelResolvers = extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        this.contributionProcessor = new ContributionContentProcessor(this.modelFactories, this.modelResolvers, urlProcessor, staxProcessor, monitor);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Contribution contribution;
        Item contributionItem;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        String key = path.startsWith("/") ? path.substring(1) : path;
        logger.fine("get " + key);
        String contributionURI = DomainManagerUtil.contributionURI(key);
        try {
            contributionItem = (Item)this.contributionCollection.get(contributionURI);
        }
        catch (NotFoundException e) {
            response.sendError(404, key);
            return;
        }
        try {
            contribution = this.contribution(contributionURI, contributionItem.getAlternate());
        }
        catch (ContributionReadException e) {
            response.sendError(404, key);
            return;
        }
        QName qname = DomainManagerUtil.compositeQName(key);
        Composite composite = null;
        for (Composite deployable : contribution.getDeployables()) {
            if (!qname.equals(deployable.getName())) continue;
            if (deployable.isUnresolved()) break;
            composite = deployable;
            break;
        }
        if (composite == null) {
            response.sendError(404, key);
            return;
        }
        response.setContentType("text/xml");
        ServletOutputStream os = response.getOutputStream();
        try {
            this.compositeProcessor.write(composite, this.outputFactory.createXMLStreamWriter((OutputStream)os));
        }
        catch (ContributionWriteException e) {
            response.sendError(500, e.toString());
            return;
        }
        catch (XMLStreamException e) {
            response.sendError(500, e.toString());
            return;
        }
        os.flush();
    }

    private Contribution contribution(String contributionURI, String contributionLocation) throws ContributionReadException {
        try {
            URI uri = URI.create(contributionURI);
            URL location = DomainManagerUtil.locationURL(contributionLocation);
            Cache.ContributionCache contributionCache = (Cache.ContributionCache)this.cache.contributions.get(location);
            long lastModified = DomainManagerUtil.lastModified(location);
            if (contributionCache != null) {
                if (contributionCache.contributionLastModified == lastModified) {
                    return contributionCache.contribution;
                }
                this.cache.contributions.remove(location);
            }
            Contribution contribution = this.contributionProcessor.read(null, uri, location);
            this.contributionProcessor.resolve(contribution, new DefaultModelResolver());
            contributionCache = new Cache.ContributionCache();
            contributionCache.contribution = contribution;
            contributionCache.contributionLastModified = lastModified;
            this.cache.contributions.put(location, contributionCache);
            return contribution;
        }
        catch (ContributionReadException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw new ContributionReadException(e);
        }
        catch (IOException e) {
            throw new ContributionReadException(e);
        }
        catch (ContributionResolveException e) {
            throw new ContributionReadException(e);
        }
    }

    static class Cache {
        private Map<URL, ContributionCache> contributions = new HashMap<URL, ContributionCache>();

        Cache() {
        }

        static class ContributionCache {
            private Contribution contribution;
            private long contributionLastModified;

            ContributionCache() {
            }
        }
    }
}

