/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.domain.manager.impl;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.data.collection.ItemCollection;
import org.apache.tuscany.sca.data.collection.LocalItemCollection;
import org.apache.tuscany.sca.data.collection.NotFoundException;
import org.apache.tuscany.sca.domain.manager.impl.DomainManagerUtil;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Scope;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value="COMPOSITE")
@Service(interfaces={ItemCollection.class, LocalItemCollection.class})
public class CompositeConfigurationCollectionImpl
implements ItemCollection,
LocalItemCollection {
    private static final Logger logger = Logger.getLogger(CompositeConfigurationCollectionImpl.class.getName());
    @Reference
    public LocalItemCollection contributionCollection;
    @Reference
    public LocalItemCollection cloudCollection;

    @Init
    public void initialize() {
    }

    @Override
    public Entry<String, Item>[] getAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item get(String key) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String post(String key, Item item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(String key, Item item) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String key) throws NotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Entry<String, Item>[] query(String queryString) {
        logger.fine("query " + queryString);
        if (queryString.startsWith("composite=")) {
            Entry<K, D>[] contributionEntries;
            int e = queryString.indexOf(61);
            String key = queryString.substring(e + 1);
            String contributionURI = DomainManagerUtil.contributionURI(key);
            QName qname = DomainManagerUtil.compositeQName(key);
            ArrayList entries = new ArrayList();
            Entry<String, Item> compositeEntry = new Entry<String, Item>();
            Item compositeItem = new Item();
            compositeItem.setTitle(DomainManagerUtil.compositeTitle(contributionURI, qname));
            compositeItem.setLink("/composite-resolved/" + key);
            compositeEntry.setKey(key);
            compositeEntry.setData(compositeItem);
            entries.add(compositeEntry);
            for (Entry entry : contributionEntries = this.contributionCollection.query("alldependencies=" + contributionURI)) {
                Item item = (Item)entry.getData();
                item.setContents(null);
                entries.add(entry);
            }
            return entries.toArray(new Entry[entries.size()]);
        }
        throw new UnsupportedOperationException();
    }
}

