/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.tuscany.sca.databinding.xml.XMLFragmentStreamReader;

public class WrappingXMLStreamReader
extends StreamReaderDelegate
implements XMLFragmentStreamReader {
    private boolean done;
    private int level;

    public WrappingXMLStreamReader(XMLStreamReader realReader) throws XMLStreamException {
        super(realReader);
        if (realReader == null) {
            throw new UnsupportedOperationException("Reader cannot be null");
        }
        if (realReader instanceof XMLFragmentStreamReader) {
            ((XMLFragmentStreamReader)realReader).init();
        }
        if (realReader.getEventType() == 7) {
            realReader.nextTag();
        }
        if (realReader.getEventType() != 1) {
            throw new IllegalStateException("The reader is not positioned at START_DOCUMENT or START_ELEMENT");
        }
        this.done = false;
        this.level = 1;
    }

    public boolean hasNext() throws XMLStreamException {
        return !this.done && super.hasNext();
    }

    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more events");
        }
        int event = super.next();
        if (!super.hasNext()) {
            this.done = true;
        }
        if (event == 1) {
            ++this.level;
        } else if (event == 2) {
            --this.level;
            if (this.level == 0) {
                this.done = true;
            }
        }
        return event;
    }

    public int nextTag() throws XMLStreamException {
        int event = 0;
        while ((event = this.next()) != 1 && event != 2) {
        }
        return event;
    }

    public void setParentNamespaceContext(NamespaceContext nsContext) {
    }

    public void init() {
    }

    public boolean isDone() {
        return this.done;
    }
}

