/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo2om;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.apache.tuscany.sca.databinding.sdo.SDODataBinding;
import org.apache.tuscany.sca.databinding.sdo2om.AxiomHelper;
import org.apache.tuscany.sca.databinding.sdo2om.SDODataSource;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObject2OMElement
extends BaseTransformer<DataObject, OMElement>
implements PullTransformer<DataObject, OMElement> {
    @Override
    public OMElement transform(DataObject source, TransformationContext context) {
        HelperContext helperContext = SDOContextHelper.getHelperContext(context, true);
        OMFactory factory = OMAbstractFactory.getOMFactory();
        QName name = SDODataBinding.ROOT_ELEMENT;
        if (context != null) {
            XMLType xmlType;
            Object logical;
            DataType dataType = context.getTargetDataType();
            Object v0 = logical = dataType == null ? null : dataType.getLogical();
            if (logical instanceof XMLType && (xmlType = (XMLType)logical).isElement()) {
                name = xmlType.getElementName();
            }
        }
        XMLDocument document = helperContext.getXMLHelper().createDocument(source, name.getNamespaceURI(), name.getLocalPart());
        SDODataSource dataSource = new SDODataSource(document, helperContext);
        OMElement element = AxiomHelper.createOMElement(factory, name, dataSource);
        return element;
    }

    @Override
    protected Class<DataObject> getSourceType() {
        return DataObject.class;
    }

    @Override
    protected Class<OMElement> getTargetType() {
        return OMElement.class;
    }

    @Override
    public int getWeight() {
        return 10;
    }
}

