/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XSDHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.apache.tuscany.sca.databinding.sdo.SDODataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOWrapperHandler
implements WrapperHandler<Object> {
    @Override
    public Object create(Operation operation, boolean input) {
        WrapperInfo wrapperInfo = operation.getWrapper();
        ElementInfo element = input ? wrapperInfo.getInputWrapperElement() : wrapperInfo.getOutputWrapperElement();
        HelperContext helperContext = SDOContextHelper.getHelperContext(operation);
        Type sdoType = this.getSDOType(helperContext, element);
        if (sdoType != null) {
            DataFactory dataFactory = helperContext.getDataFactory();
            return dataFactory.create(sdoType);
        }
        return null;
    }

    @Override
    public void setChildren(Object wrapper, Object[] childObjects, Operation operation, boolean input) {
        List<ElementInfo> childElements = input ? operation.getWrapper().getInputChildElements() : operation.getWrapper().getOutputChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            this.setChild(wrapper, i, childElements.get(i), childObjects[i]);
        }
    }

    public void setChild(Object wrapper, int i, ElementInfo childElement, Object value) {
        DataObject wrapperDO = wrapper instanceof XMLDocument ? ((XMLDocument)wrapper).getRootObject() : (DataObject)wrapper;
        String name = childElement.getQName().getLocalPart();
        if (childElement.isMany()) {
            wrapperDO.getList(i).addAll((Collection)value);
        } else {
            wrapperDO.set(i, value);
        }
    }

    @Override
    public List getChildren(Object wrapper, Operation operation, boolean input) {
        DataObject wrapperDO = wrapper instanceof XMLDocument ? ((XMLDocument)wrapper).getRootObject() : (DataObject)wrapper;
        List properties = wrapperDO.getInstanceProperties();
        ArrayList<Object> elements = new ArrayList<Object>();
        Type type = wrapperDO.getType();
        if (type.isSequenced()) {
            Sequence sequence = wrapperDO.getSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                if (sequence.getProperty(i) == null) continue;
                elements.add(sequence.getValue(i));
            }
        } else {
            for (Property p : properties) {
                Object child = wrapperDO.get(p);
                if (p.isMany()) {
                    for (Object c : (Collection)child) {
                        elements.add(c);
                    }
                    continue;
                }
                elements.add(child);
            }
        }
        return elements;
    }

    @Override
    public DataType getWrapperType(Operation operation, boolean input) {
        WrapperInfo wrapper = operation.getWrapper();
        ElementInfo element = input ? wrapper.getInputWrapperElement() : wrapper.getOutputWrapperElement();
        HelperContext helperContext = SDOContextHelper.getHelperContext(operation);
        Type sdoType = this.getSDOType(helperContext, element);
        if (sdoType != null) {
            Class physical = sdoType.getInstanceClass();
            DataTypeImpl<XMLType> wrapperType = new DataTypeImpl<XMLType>(SDODataBinding.NAME, physical, new XMLType(element));
            return wrapperType;
        }
        return null;
    }

    private Type getSDOType(HelperContext helperContext, ElementInfo element) {
        XSDHelper xsdHelper = helperContext.getXSDHelper();
        Type sdoType = null;
        Property prop = xsdHelper.getGlobalProperty(element.getQName().getNamespaceURI(), element.getQName().getLocalPart(), true);
        if (prop != null) {
            sdoType = prop.getType();
        } else {
            QName typeName;
            TypeInfo type = element.getType();
            QName qName = typeName = type != null ? type.getQName() : null;
            if (typeName != null) {
                sdoType = helperContext.getTypeHelper().getType(typeName.getNamespaceURI(), typeName.getLocalPart());
            }
        }
        return sdoType;
    }

    @Override
    public boolean isInstance(Object wrapper, Operation operation, boolean input) {
        WrapperInfo wrapperInfo = operation.getWrapper();
        ElementInfo element = input ? wrapperInfo.getInputWrapperElement() : wrapperInfo.getOutputWrapperElement();
        HelperContext helperContext = SDOContextHelper.getHelperContext(operation);
        Type sdoType = this.getSDOType(helperContext, element);
        if (sdoType != null) {
            return sdoType.isInstance(wrapper);
        }
        return false;
    }
}

