/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XSDHelper;
import java.beans.Introspector;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.apache.tuscany.sca.databinding.sdo.SDODataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.osoa.sca.ServiceRuntimeException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOTypeHelper
implements XMLTypeHelper {
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private TypeHelper typeHelper = SDOContextHelper.getDefaultHelperContext().getTypeHelper();
    private XSDHelper xsdHelper = SDOContextHelper.getDefaultHelperContext().getXSDHelper();

    @Override
    public TypeInfo getTypeInfo(Class javaType, Object logical) {
        QName xmlType = JavaXMLMapper.getXMLType(javaType);
        if (xmlType != null) {
            return new TypeInfo(xmlType, true, null);
        }
        if (logical instanceof XMLType) {
            xmlType = ((XMLType)logical).getTypeName();
        }
        if (xmlType == null) {
            xmlType = new QName(JavaXMLMapper.getNamespace(javaType), Introspector.decapitalize(javaType.getSimpleName()));
        }
        return new TypeInfo(xmlType, false, null);
    }

    private void introspect(Class javaType, Map<String, List<Type>> xsdTypesMap, Map<String, List<Type>> typesMap) {
        Type type = this.typeHelper.getType(javaType);
        if (type == null) {
            return;
        }
        if (this.xsdHelper.isXSD(type)) {
            this.addToMap(xsdTypesMap, type);
        } else {
            this.addToMap(typesMap, type);
        }
    }

    private void addToMap(Map<String, List<Type>> map, Type type) {
        List<Type> types = map.get(type.getURI());
        if (types == null) {
            types = new ArrayList<Type>();
            map.put(type.getURI(), types);
        }
        if (!types.contains(type)) {
            types.add(type);
        }
    }

    private void generateSDOSchemas(List<XSDefinition> definitions, XSDFactory factory, Map<String, List<Type>> map) {
        for (Map.Entry<String, List<Type>> entry : map.entrySet()) {
            List<Type> types = entry.getValue();
            String ns = entry.getKey();
            this.generateSchema(definitions, factory, types, ns);
        }
    }

    private void generateSchema(List<XSDefinition> definitions, XSDFactory factory, List<Type> types, String ns) {
        String schema = this.xsdHelper.generate(types);
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        DOMImplementation impl = registry.getDOMImplementation("XML 3.0");
        DOMImplementationLS ls = (DOMImplementationLS)impl.getFeature("LS", "3.0");
        LSParser parser = ls.createLSParser((short)1, SCHEMA_NS);
        LSInput input = ls.createLSInput();
        input.setCharacterStream(new StringReader(schema));
        Document document = parser.parse(input);
        XSDefinition definition = factory.createXSDefinition();
        definition.setUnresolved(true);
        definition.setDocument(document);
        definition.setNamespace(ns);
        definitions.add(definition);
    }

    private void addResolvedXSDs(List<XSDefinition> definitions, XSDFactory factory, ModelResolver resolver, Map<String, List<Type>> map) {
        for (Map.Entry<String, List<Type>> entry : map.entrySet()) {
            XSDefinition definition = factory.createXSDefinition();
            definition.setUnresolved(true);
            definition.setNamespace(entry.getKey());
            XSDefinition resolved = resolver.resolveModel(XSDefinition.class, definition);
            if (resolved.getSchema() == null) {
                throw new RuntimeException("No XSD found for namespace " + entry.getKey());
            }
            for (Type type : entry.getValue()) {
                String name = this.xsdHelper.getLocalName(type);
                QName typeName = null;
                if (name.endsWith("_._type")) {
                    name = name.substring(0, name.length() - "_._type".length());
                    typeName = new QName(type.getURI(), name);
                    if (resolved.getXmlSchemaElement(typeName) != null) continue;
                    throw new RuntimeException("No XSD found for " + typeName.toString());
                }
                typeName = new QName(type.getURI(), name);
                if (resolved.getXmlSchemaType(typeName) != null) continue;
                throw new RuntimeException("No XSD found for " + typeName.toString());
            }
            definitions.add(resolved);
        }
    }

    private static List<DataType> getDataTypes(Interface intf) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Operation op : intf.getOperations()) {
            WrapperInfo wrapper = op.getWrapper();
            if (wrapper != null) {
                DataType<XMLType> dt2;
                DataType<XMLType> dt1 = wrapper.getInputWrapperType();
                if (dt1 != null) {
                    dataTypes.add(dt1);
                }
                if ((dt2 = wrapper.getOutputWrapperType()) == null) continue;
                dataTypes.add(dt2);
                continue;
            }
            for (DataType dt1 : op.getInputType().getLogical()) {
                dataTypes.add(dt1);
            }
            DataType dt2 = op.getOutputType();
            if (dt2 != null) {
                dataTypes.add(dt2);
            }
            for (DataType dt3 : op.getFaultTypes()) {
                DataType dt4 = (DataType)dt3.getLogical();
                if (dt4 == null) continue;
                dataTypes.add(dt4);
            }
        }
        return dataTypes;
    }

    @Override
    public List<XSDefinition> getSchemaDefinitions(XSDFactory factory, ModelResolver resolver, Interface intf) {
        return this.getSchemaDefinitions(factory, resolver, SDOTypeHelper.getDataTypes(intf));
    }

    @Override
    public List<XSDefinition> getSchemaDefinitions(XSDFactory factory, ModelResolver resolver, List<DataType> dataTypes) {
        HashMap<String, List<Type>> xsdTypesMap = new HashMap<String, List<Type>>();
        HashMap<String, List<Type>> typesMap = new HashMap<String, List<Type>>();
        for (DataType d : dataTypes) {
            if (!SDODataBinding.NAME.equals(d.getDataBinding())) continue;
            this.introspect(d.getPhysical(), xsdTypesMap, typesMap);
        }
        ArrayList<XSDefinition> definitions = new ArrayList<XSDefinition>();
        this.generateSDOSchemas(definitions, factory, typesMap);
        this.addResolvedXSDs(definitions, factory, resolver, xsdTypesMap);
        return definitions;
    }
}

