/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.apache.tuscany.sdo.api.SDOUtil;

public class SDOSimpleTypeMapper
implements SimpleTypeMapper {
    public static final String URI_2001_SCHEMA_XSD = "http://www.w3.org/2001/XMLSchema";

    public Object toJavaObject(QName typeName, String value, TransformationContext context) {
        Type type = null;
        if (URI_2001_SCHEMA_XSD.equals(typeName.getNamespaceURI())) {
            type = SDOUtil.getXSDSDOType(typeName.getLocalPart());
        } else {
            HelperContext helperContext = SDOContextHelper.getHelperContext(context, false);
            TypeHelper typeHelper = helperContext.getTypeHelper();
            type = typeHelper.getType(typeName.getNamespaceURI(), typeName.getLocalPart());
        }
        return SDOUtil.createFromString(type, value);
    }

    public String toXMLLiteral(QName typeName, Object obj, TransformationContext context) {
        Type type = null;
        if (URI_2001_SCHEMA_XSD.equals(typeName.getNamespaceURI())) {
            type = SDOUtil.getXSDSDOType(typeName.getLocalPart());
        } else {
            HelperContext helperContext = SDOContextHelper.getHelperContext(context, true);
            TypeHelper typeHelper = helperContext.getTypeHelper();
            type = typeHelper.getType(typeName.getNamespaceURI(), typeName.getLocalPart());
        }
        return SDOUtil.convertToString(type, obj);
    }
}

