/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.databinding.impl.BaseDataBinding;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.apache.tuscany.sca.databinding.sdo.SDOTypeHelper;
import org.apache.tuscany.sca.databinding.sdo.SDOWrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sdo.api.SDOUtil;

public class SDODataBinding
extends BaseDataBinding {
    public static final String NAME = DataObject.class.getName();
    public static final String ROOT_NAMESPACE = "commonj.sdo";
    public static final QName ROOT_ELEMENT = new QName("commonj.sdo", "dataObject");
    private WrapperHandler<Object> wrapperHandler = new SDOWrapperHandler();
    private XMLTypeHelper xmlTypeHelper = new SDOTypeHelper();

    public SDODataBinding() {
        super(NAME, DataObject.class);
    }

    public boolean introspect(DataType dataType, final Operation operation) {
        final Class<?> javaType = dataType.getPhysical();
        final HelperContext context = AccessController.doPrivileged(new PrivilegedAction<HelperContext>(){

            @Override
            public HelperContext run() {
                return SDOContextHelper.getHelperContext(operation);
            }
        });
        Type type = context.getTypeHelper().getType(javaType);
        if (type == null) {
            if (DataObject.class.isAssignableFrom(javaType)) {
                dataType.setDataBinding(this.getName());
                if (dataType.getLogical() == null) {
                    dataType.setLogical(XMLType.UNKNOWN);
                }
                return true;
            }
            return false;
        }
        if (type.isDataType()) {
            return false;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (context == SDOContextHelper.getDefaultHelperContext()) {
                    HelperContext newContext = SDOUtil.createHelperContext();
                    SDOContextHelper.register(newContext, javaType);
                    if (operation != null) {
                        operation.getInputType().setMetaData(HelperContext.class, newContext);
                    }
                }
                return null;
            }
        });
        String namespace = type.getURI();
        String name = context.getXSDHelper().getLocalName(type);
        QName xmlType = new QName(namespace, name);
        dataType.setDataBinding(this.getName());
        QName elementName = null;
        Object logical = dataType.getLogical();
        if (logical instanceof XMLType) {
            elementName = ((XMLType)logical).getElementName();
        }
        dataType.setLogical(new XMLType(elementName, xmlType));
        return true;
    }

    public WrapperHandler getWrapperHandler() {
        return this.wrapperHandler;
    }

    public XMLTypeHelper getXMLTypeHelper() {
        return this.xmlTypeHelper;
    }

    public Object copy(Object arg, DataType dataType, Operation operation) {
        HelperContext context = SDOContextHelper.getHelperContext(operation);
        CopyHelper copyHelper = context.getCopyHelper();
        if (arg instanceof XMLDocument) {
            XMLDocument document = (XMLDocument)arg;
            DataObject dataObject = copyHelper.copy(document.getRootObject());
            return context.getXMLHelper().createDocument(dataObject, document.getRootElementURI(), document.getRootElementName());
        }
        if (arg instanceof DataObject) {
            return context.getCopyHelper().copy((DataObject)arg);
        }
        return super.copy(arg, dataType, operation);
    }
}

