/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.tuscany.sdo.api.XMLStreamHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObject2XMLStreamReader
extends BaseTransformer<DataObject, XMLStreamReader>
implements PullTransformer<DataObject, XMLStreamReader> {
    @Override
    public XMLStreamReader transform(final DataObject source, TransformationContext context) {
        if (source == null) {
            return null;
        }
        try {
            HelperContext helperContext = SDOContextHelper.getHelperContext(context, true);
            XMLStreamHelper streamHelper = SDOUtil.createXMLStreamHelper(helperContext);
            final QName elementName = SDOContextHelper.getElement(context);
            final XMLHelper xmlHelper = helperContext.getXMLHelper();
            XMLDocument document = AccessController.doPrivileged(new PrivilegedAction<XMLDocument>(){

                @Override
                public XMLDocument run() {
                    return xmlHelper.createDocument(source, elementName.getNamespaceURI(), elementName.getLocalPart());
                }
            });
            return streamHelper.createXMLStreamReader(document);
        }
        catch (XMLStreamException e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<DataObject> getSourceType() {
        return DataObject.class;
    }

    @Override
    protected Class<XMLStreamReader> getTargetType() {
        return XMLStreamReader.class;
    }

    @Override
    public int getWeight() {
        return 10;
    }
}

