/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XMLHelper;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMResult;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.impl.BaseTransformer;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.apache.tuscany.sca.databinding.sdo.SDOContextHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObject2Node
extends BaseTransformer<DataObject, Node>
implements PullTransformer<DataObject, Node> {
    @Override
    public Node transform(DataObject source, TransformationContext context) {
        if (source == null) {
            return null;
        }
        try {
            HelperContext helperContext = SDOContextHelper.getHelperContext(context, true);
            XMLHelper xmlHelper = helperContext.getXMLHelper();
            QName elementName = SDOContextHelper.getElement(context);
            Document doc = DOMHelper.newDocument();
            DOMResult result = new DOMResult(doc);
            XMLDocument xmlDoc = xmlHelper.createDocument(source, elementName.getNamespaceURI(), elementName.getLocalPart());
            xmlHelper.save(xmlDoc, result, null);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<DataObject> getSourceType() {
        return DataObject.class;
    }

    @Override
    protected Class<Node> getTargetType() {
        return Node.class;
    }

    @Override
    public int getWeight() {
        return 40;
    }
}

