/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom.ext;

import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.axiom.ext.XMLStreamWriterWithOS;

public class JAXBDSContext {
    private static final Logger log = Logger.getLogger(JAXBDSContext.class.getName());
    private static final boolean DEBUG_ENABLED = log.isLoggable(Level.FINER);
    private JAXBContext jaxbContext = null;

    public JAXBDSContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        Unmarshaller u = JAXBContextHelper.getUnmarshaller(this.getJAXBContext());
        Object jaxb = null;
        jaxb = JAXBDSContext.unmarshalElement(u, reader);
        return jaxb;
    }

    public void marshal(Object obj, XMLStreamWriter writer) throws JAXBException {
        Marshaller m = JAXBContextHelper.getMarshaller(this.getJAXBContext());
        AttachmentMarshaller am = m.getAttachmentMarshaller();
        boolean xop = am != null ? am.isXOPPackage() : false;
        JAXBDSContext.marshalElement(obj, m, writer, !xop);
    }

    private static void marshalElement(final Object b, final Marshaller m, final XMLStreamWriter writer, final boolean optimize) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    OutputStream os;
                    OutputStream outputStream = os = optimize ? JAXBDSContext.getOutputStream(writer) : null;
                    if (os != null) {
                        writer.flush();
                        m.marshal(b, os);
                    } else {
                        m.marshal(b, writer);
                    }
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
                return null;
            }
        });
    }

    private static OutputStream getOutputStream(XMLStreamWriter writer) throws XMLStreamException {
        if (writer.getClass() == MTOMXMLStreamWriter.class) {
            return ((MTOMXMLStreamWriter)writer).getOutputStream();
        }
        if (writer.getClass() == XMLStreamWriterWithOS.class) {
            return ((XMLStreamWriterWithOS)writer).getOutputStream();
        }
        return null;
    }

    private static Object unmarshalElement(final Unmarshaller u, final XMLStreamReader reader) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return u.unmarshal(reader);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            });
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }
}

