/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;

public class JAXBDataSource
implements OMDataSource {
    private JAXBContext context;
    private Object element;
    private Marshaller marshaller;

    public JAXBDataSource(Object element, JAXBContext context) {
        this.element = element;
        this.context = context;
    }

    private Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.marshaller = JAXBContextHelper.getMarshaller(this.context);
        }
        return this.marshaller;
    }

    private void releaseMarshaller(Marshaller marshaller) {
        JAXBContextHelper.releaseJAXBMarshaller(this.context, marshaller);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        this.serialize(writer, new OMOutputFormat());
        StringReader reader = new StringReader(writer.toString());
        return StAXUtils.createXMLStreamReader((Reader)reader);
    }

    public void serialize(final XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    try {
                        Marshaller marshaller = JAXBDataSource.this.getMarshaller();
                        marshaller.marshal(JAXBDataSource.this.element, xmlWriter);
                    }
                    finally {
                        JAXBDataSource.this.releaseMarshaller(JAXBDataSource.this.marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    public void serialize(final OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    try {
                        Marshaller marshaller = JAXBDataSource.this.getMarshaller();
                        marshaller.marshal(JAXBDataSource.this.element, output);
                    }
                    finally {
                        JAXBDataSource.this.releaseMarshaller(JAXBDataSource.this.marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    public void serialize(final Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    try {
                        Marshaller marshaller = JAXBDataSource.this.getMarshaller();
                        marshaller.marshal(JAXBDataSource.this.element, writer);
                    }
                    finally {
                        JAXBDataSource.this.releaseMarshaller(JAXBDataSource.this.marshaller);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new XMLStreamException(e.getException());
        }
    }

    public Object getObject() {
        return this.element;
    }
}

