/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.databinding.jaxb.JAXBPropertyDescriptor;
import org.apache.tuscany.sca.databinding.jaxb.JAXBWrapperException;
import org.apache.tuscany.sca.databinding.jaxb.XMLRootElementUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBWrapperHelper {
    public Object[] unwrap(Object jaxbObject, List<String> childNames, Map<String, JAXBPropertyDescriptor> pdMap) throws JAXBWrapperException {
        Object jaxbComplexTypeObj = jaxbObject;
        ArrayList<Object> objList = new ArrayList<Object>();
        int index = 0;
        for (String childName : childNames) {
            JAXBPropertyDescriptor propInfo = this.getPropertyDescriptor(pdMap, childName, index);
            Object object = null;
            try {
                object = propInfo.get(jaxbComplexTypeObj);
            }
            catch (Throwable e) {
                throw new JAXBWrapperException(e);
            }
            objList.add(object);
            ++index;
        }
        Object[] jaxbObjects = objList.toArray();
        objList = null;
        return jaxbObjects;
    }

    private JAXBPropertyDescriptor getPropertyDescriptor(Map<String, JAXBPropertyDescriptor> pdMap, String childName, int index) {
        JAXBPropertyDescriptor propInfo = pdMap.get(childName);
        if (propInfo == null) {
            ArrayList<JAXBPropertyDescriptor> props = new ArrayList<JAXBPropertyDescriptor>(pdMap.values());
            Collections.sort(props);
            propInfo = (JAXBPropertyDescriptor)props.get(index);
        }
        return propInfo;
    }

    public Object wrap(Class<?> jaxbClass, List<String> childNames, Map<String, Object> childObjects, Map<String, JAXBPropertyDescriptor> pdMap) throws JAXBWrapperException {
        Object jaxbObject = null;
        try {
            jaxbObject = jaxbClass.newInstance();
        }
        catch (Throwable t) {
            throw new JAXBWrapperException(t);
        }
        this.wrap((Object)jaxbObject, childNames, childObjects, pdMap);
        return jaxbObject;
    }

    public void wrap(Object jaxbObject, List<String> childNames, Map<String, Object> childObjects, Map<String, JAXBPropertyDescriptor> pdMap) {
        int index = 0;
        for (String childName : childNames) {
            JAXBPropertyDescriptor propInfo = this.getPropertyDescriptor(pdMap, childName, index);
            Object value = childObjects.get(childName);
            try {
                propInfo.set(jaxbObject, value);
            }
            catch (Throwable t) {
                throw new JAXBWrapperException(t);
            }
            ++index;
        }
    }

    public Object[] unwrap(Object jaxbObject, List<String> childNames) throws JAXBWrapperException {
        Class<?> jaxbClass = jaxbObject.getClass();
        Map<String, JAXBPropertyDescriptor> pdMap = null;
        try {
            pdMap = XMLRootElementUtil.createPropertyDescriptorMap(jaxbClass);
        }
        catch (Throwable t) {
            throw new JAXBWrapperException(t);
        }
        return this.unwrap(jaxbObject, childNames, pdMap);
    }

    public Object wrap(Class<?> jaxbClass, List<String> childNames, Map<String, Object> childObjects) throws JAXBWrapperException {
        Map<String, JAXBPropertyDescriptor> pdMap = null;
        try {
            pdMap = XMLRootElementUtil.createPropertyDescriptorMap(jaxbClass);
        }
        catch (Throwable t) {
            throw new JAXBWrapperException(t);
        }
        return this.wrap(jaxbClass, childNames, childObjects, pdMap);
    }
}

